/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.repository.support;

import com.google.cloud.datastore.Cursor;
import com.google.cloud.datastore.Key;
import com.google.cloud.spring.data.datastore.core.DatastoreOperations;
import com.google.cloud.spring.data.datastore.core.DatastoreQueryOptions;
import com.google.cloud.spring.data.datastore.core.DatastoreResultsCollection;
import com.google.cloud.spring.data.datastore.core.DatastoreResultsIterable;
import com.google.cloud.spring.data.datastore.repository.DatastoreRepository;
import com.google.cloud.spring.data.datastore.repository.query.DatastorePageable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Example;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class SimpleDatastoreRepository<T, ID>
implements DatastoreRepository<T, ID> {
    private final DatastoreOperations datastoreTemplate;
    private final Class<T> entityType;

    public SimpleDatastoreRepository(DatastoreOperations datastoreTemplate, Class<T> entityType) {
        Assert.notNull((Object)datastoreTemplate, (String)"A non-null DatastoreOperations is required.");
        Assert.notNull(entityType, (String)"A non-null entity type is required.");
        this.datastoreTemplate = datastoreTemplate;
        this.entityType = entityType;
    }

    @Override
    public <A> A performTransaction(Function<DatastoreRepository<T, ID>, A> operations) {
        return (A)this.datastoreTemplate.performTransaction((DatastoreOperations template) -> operations.apply(new SimpleDatastoreRepository<T, ID>((DatastoreOperations)template, this.entityType)));
    }

    public Iterable<T> findAll(Sort sort) {
        Assert.notNull((Object)sort, (String)"A non-null Sort is required.");
        return this.datastoreTemplate.findAll(this.entityType, new DatastoreQueryOptions.Builder().setSort(sort).build());
    }

    public Page<T> findAll(Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"A non-null Pageable is required.");
        Collection<T> entities = this.datastoreTemplate.findAll(this.entityType, new DatastoreQueryOptions.Builder().setLimit(pageable.getPageSize()).setOffset((int)pageable.getOffset()).setSort(pageable.getSort()).setCursor(SimpleDatastoreRepository.getCursor(pageable)).build());
        Long totalCount = SimpleDatastoreRepository.getOrComputeTotalCount(pageable, () -> this.datastoreTemplate.count(this.entityType));
        Pageable cursorPageable = DatastorePageable.from(pageable, entities instanceof DatastoreResultsCollection ? ((DatastoreResultsCollection)entities).getCursor() : null, totalCount);
        return new PageImpl(entities != null ? new ArrayList<T>(entities) : Collections.emptyList(), cursorPageable, totalCount.longValue());
    }

    public <S extends T> S save(S entity) {
        return this.datastoreTemplate.save(entity, new Key[0]);
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        return this.datastoreTemplate.saveAll(entities, new Key[0]);
    }

    public Optional<T> findById(ID id) {
        return Optional.ofNullable(this.datastoreTemplate.findById(id, this.entityType));
    }

    public boolean existsById(ID id) {
        return this.datastoreTemplate.existsById(id, this.entityType);
    }

    public Iterable<T> findAll() {
        return this.datastoreTemplate.findAll(this.entityType);
    }

    public Iterable<T> findAllById(Iterable<ID> ids) {
        return this.datastoreTemplate.findAllById(ids, this.entityType);
    }

    public long count() {
        return this.datastoreTemplate.count(this.entityType);
    }

    public void deleteById(ID id) {
        this.datastoreTemplate.deleteById(id, this.entityType);
    }

    public void delete(T entity) {
        this.datastoreTemplate.delete(entity);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        this.datastoreTemplate.deleteAll(entities);
    }

    public void deleteAll() {
        this.datastoreTemplate.deleteAll(this.entityType);
    }

    public <S extends T> Optional<S> findOne(Example<S> example) {
        Iterable<S> entities = this.datastoreTemplate.queryByExample(example, new DatastoreQueryOptions.Builder().setLimit(1).build());
        Iterator<S> iterator = entities.iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    public <S extends T> Iterable<S> findAll(Example<S> example) {
        return this.datastoreTemplate.queryByExample(example, null);
    }

    public <S extends T> Iterable<S> findAll(Example<S> example, Sort sort) {
        return this.datastoreTemplate.queryByExample(example, new DatastoreQueryOptions.Builder().setSort(sort).build());
    }

    public <S extends T> Page<S> findAll(Example<S> example, Pageable pageable) {
        Assert.notNull((Object)pageable, (String)"A non-null pageable is required.");
        Iterable<S> entities = this.datastoreTemplate.queryByExample(example, new DatastoreQueryOptions.Builder().setLimit(pageable.getPageSize()).setOffset((int)pageable.getOffset()).setSort(pageable.getSort()).setCursor(SimpleDatastoreRepository.getCursor(pageable)).build());
        List result = StreamSupport.stream(entities.spliterator(), false).collect(Collectors.toList());
        Long totalCount = SimpleDatastoreRepository.getOrComputeTotalCount(pageable, () -> this.count(example));
        Pageable cursorPageable = DatastorePageable.from(pageable, entities instanceof DatastoreResultsIterable ? ((DatastoreResultsIterable)entities).getCursor() : null, totalCount);
        return new PageImpl(result, cursorPageable, totalCount.longValue());
    }

    public <S extends T> long count(Example<S> example) {
        Iterable<Key> keys = this.datastoreTemplate.keyQueryByExample(example, null);
        return StreamSupport.stream(keys.spliterator(), false).count();
    }

    public <S extends T> boolean exists(Example<S> example) {
        Iterable<Key> keys = this.datastoreTemplate.keyQueryByExample(example, new DatastoreQueryOptions.Builder().setLimit(1).build());
        return StreamSupport.stream(keys.spliterator(), false).findAny().isPresent();
    }

    private static Cursor getCursor(Pageable pageable) {
        return pageable instanceof DatastorePageable ? ((DatastorePageable)pageable).toCursor() : null;
    }

    private static Long getOrComputeTotalCount(Pageable pageable, Supplier<Long> countCall) {
        return pageable instanceof DatastorePageable ? ((DatastorePageable)pageable).getTotalCount() : countCall.get();
    }
}

