/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.convert;

import com.google.cloud.datastore.BaseKey;
import com.google.cloud.datastore.Key;
import com.google.cloud.spring.data.datastore.core.convert.DatastoreNativeTypes;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreDataException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.Jsr310Converters;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.lang.NonNull;

public class DatastoreCustomConversions
extends CustomConversions {
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;
    private static final List<Converter<?, ?>> STORE_CONVERTERS;

    public DatastoreCustomConversions() {
        this(Collections.emptyList());
    }

    public DatastoreCustomConversions(List<?> converters) {
        super(STORE_CONVERSIONS, converters);
    }

    static {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(Jsr310Converters.getConvertersToRegister());
        converters.add(new Converter<BaseKey, Long>(){

            public Long convert(@NonNull BaseKey baseKey) {
                Key key;
                Long id = null;
                if (baseKey instanceof Key && (id = (key = (Key)baseKey).getId()) == null) {
                    throw new DatastoreDataException("The given key doesn't have a numeric ID but a conversion to Long was attempted: " + key);
                }
                return id;
            }
        });
        converters.add(new Converter<BaseKey, String>(){

            public String convert(@NonNull BaseKey baseKey) {
                Key key;
                String name = null;
                if (baseKey instanceof Key && (name = (key = (Key)baseKey).getName()) == null) {
                    throw new DatastoreDataException("The given key doesn't have a String name value but a conversion to String was attempted: " + key);
                }
                return name;
            }
        });
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)DatastoreNativeTypes.HOLDER, STORE_CONVERTERS);
    }
}

