/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.mapping;

import com.google.cloud.spring.data.datastore.core.mapping.Entity;
import org.springframework.data.util.TypeInformation;

public enum EmbeddedType {
    NOT_EMBEDDED,
    EMBEDDED_ENTITY,
    EMBEDDED_MAP;


    public static EmbeddedType of(TypeInformation<?> typeInformation) {
        EmbeddedType embeddedType = typeInformation.isMap() ? EMBEDDED_MAP : (typeInformation.isCollectionLike() && EmbeddedType.isEntity(typeInformation.getComponentType()) || EmbeddedType.isEntity(typeInformation) ? EMBEDDED_ENTITY : NOT_EMBEDDED);
        return embeddedType;
    }

    private static boolean isEntity(TypeInformation<?> componentType) {
        if (componentType == null) {
            return false;
        }
        Class type = componentType.getType();
        return type.isAnnotationPresent(Entity.class);
    }
}

