/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.core.util;

import java.util.Arrays;
import java.util.function.Consumer;

public final class SliceUtil {
    private SliceUtil() {
    }

    public static <T> void sliceAndExecute(T[] elements, int sliceSize, Consumer<T[]> consumer) {
        int numSlices = (int)Math.ceil((double)elements.length / (double)sliceSize);
        for (int i = 0; i < numSlices; ++i) {
            int start = i * sliceSize;
            int end = Math.min(start + sliceSize, elements.length);
            T[] slice = Arrays.copyOfRange(elements, start, end);
            consumer.accept(slice);
        }
    }
}

