/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.datastore.repository.support;

import com.google.cloud.spring.data.datastore.aot.DatastoreRepositoryRuntimeHints;
import com.google.cloud.spring.data.datastore.core.DatastoreTemplate;
import com.google.cloud.spring.data.datastore.core.mapping.DatastoreMappingContext;
import com.google.cloud.spring.data.datastore.repository.support.DatastoreRepositoryFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.ImportRuntimeHints;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;

@ImportRuntimeHints(value={DatastoreRepositoryRuntimeHints.class})
public class DatastoreRepositoryFactoryBean<T extends Repository<S, I>, S, I>
extends RepositoryFactoryBeanSupport<T, S, I>
implements ApplicationContextAware {
    private DatastoreMappingContext datastoreMappingContext;
    private DatastoreTemplate datastoreTemplate;
    private ApplicationContext applicationContext;

    DatastoreRepositoryFactoryBean(Class<T> repositoryInterface) {
        super(repositoryInterface);
    }

    public void setDatastoreTemplate(DatastoreTemplate datastoreTemplate) {
        this.datastoreTemplate = datastoreTemplate;
    }

    public void setDatastoreMappingContext(DatastoreMappingContext mappingContext) {
        super.setMappingContext((MappingContext)mappingContext);
        this.datastoreMappingContext = mappingContext;
    }

    protected RepositoryFactorySupport createRepositoryFactory() {
        DatastoreRepositoryFactory datastoreRepositoryFactory = new DatastoreRepositoryFactory(this.datastoreMappingContext, this.datastoreTemplate);
        datastoreRepositoryFactory.setApplicationContext(this.applicationContext);
        return datastoreRepositoryFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

