/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.firestore;

import com.google.cloud.Timestamp;
import com.google.cloud.firestore.FieldPath;
import com.google.cloud.firestore.Internal;
import com.google.cloud.spring.data.firestore.FirestoreDataException;
import com.google.cloud.spring.data.firestore.FirestoreReactiveOperations;
import com.google.cloud.spring.data.firestore.mapping.FirestoreClassMapper;
import com.google.cloud.spring.data.firestore.mapping.FirestoreMappingContext;
import com.google.cloud.spring.data.firestore.mapping.FirestorePersistentEntity;
import com.google.cloud.spring.data.firestore.mapping.FirestorePersistentProperty;
import com.google.cloud.spring.data.firestore.mapping.UpdateTime;
import com.google.cloud.spring.data.firestore.transaction.ReactiveFirestoreResourceHolder;
import com.google.cloud.spring.data.firestore.util.ObservableReactiveUtil;
import com.google.cloud.spring.data.firestore.util.Util;
import com.google.firestore.v1.CommitRequest;
import com.google.firestore.v1.Document;
import com.google.firestore.v1.DocumentMask;
import com.google.firestore.v1.FirestoreGrpc;
import com.google.firestore.v1.GetDocumentRequest;
import com.google.firestore.v1.Precondition;
import com.google.firestore.v1.RunQueryRequest;
import com.google.firestore.v1.RunQueryResponse;
import com.google.firestore.v1.StructuredQuery;
import com.google.firestore.v1.Write;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.transaction.reactive.TransactionContext;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class FirestoreTemplate
implements FirestoreReactiveOperations {
    private FirestoreClassMapper classMapper;
    private static final int FIRESTORE_WRITE_MAX_SIZE = 500;
    public static final String NAME_FIELD = FieldPath.documentId().toString();
    private static final StructuredQuery.Projection ID_PROJECTION = StructuredQuery.Projection.newBuilder().addFields(StructuredQuery.FieldReference.newBuilder().setFieldPath(NAME_FIELD).build()).build();
    private static final DocumentMask NAME_ONLY_MASK = DocumentMask.newBuilder().addFieldPaths(NAME_FIELD).build();
    private static final String NOT_FOUND_DOCUMENT_MESSAGE = "NOT_FOUND: Document";
    private final FirestoreGrpc.FirestoreStub firestoreStub;
    private final String parent;
    private final String databasePath;
    private final FirestoreMappingContext mappingContext;
    private Duration writeBufferTimeout = Duration.ofMillis(500L);
    private int writeBufferSize = 500;

    public FirestoreTemplate(FirestoreGrpc.FirestoreStub firestoreStub, String parent, FirestoreClassMapper classMapper, FirestoreMappingContext mappingContext) {
        this.firestoreStub = firestoreStub;
        this.parent = parent;
        this.databasePath = Util.extractDatabasePath(parent);
        this.classMapper = classMapper;
        this.mappingContext = mappingContext;
    }

    public void setWriteBufferTimeout(Duration bufferTimeout) {
        this.writeBufferTimeout = bufferTimeout;
    }

    public Duration getWriteBufferTimeout() {
        return this.writeBufferTimeout;
    }

    public void setWriteBufferSize(int bufferWriteSize) {
        Assert.isTrue((bufferWriteSize <= 500 ? 1 : 0) != 0, (String)"The FirestoreTemplate buffer write size must be less than 500");
        this.writeBufferSize = bufferWriteSize;
    }

    public int getWriteBufferSize() {
        return this.writeBufferSize;
    }

    @Override
    public <T> Mono<Boolean> existsById(Publisher<String> idPublisher, Class<T> entityClass) {
        return Flux.from(idPublisher).next().flatMap(id -> this.getDocument((String)id, entityClass, NAME_ONLY_MASK)).map(d -> true).switchIfEmpty(Mono.just((Object)false)).onErrorMap(throwable -> new FirestoreDataException("Unable to determine if document exists", (Throwable)throwable));
    }

    @Override
    public <T> Mono<T> findById(Publisher<String> idPublisher, Class<T> entityClass) {
        return this.findAllById(idPublisher, entityClass).next();
    }

    @Override
    public <T> Flux<T> findAllById(Publisher<String> idPublisher, Class<T> entityClass) {
        return Flux.from(idPublisher).flatMap(id -> this.getDocument((String)id, entityClass, null)).onErrorMap(throwable -> new FirestoreDataException("Error while reading entries by id", (Throwable)throwable)).map(document -> this.getClassMapper().documentToEntity((Document)document, entityClass));
    }

    @Override
    public <T> Mono<T> save(T entity) {
        return this.saveAll((Publisher<T>)Mono.just(entity)).next();
    }

    @Override
    public <T> Flux<T> saveAll(Publisher<T> instances) {
        return Flux.deferContextual(ctx -> {
            Optional transactionContext = ctx.getOrEmpty(TransactionContext.class);
            if (transactionContext.isPresent()) {
                ReactiveFirestoreResourceHolder holder = (ReactiveFirestoreResourceHolder)((Object)((Object)((TransactionContext)transactionContext.get()).getResources().get(this.firestoreStub)));
                return Flux.from((Publisher)instances).doOnNext(t -> {
                    holder.getWrites().add(this.createUpdateWrite(t));
                    holder.getEntities().add(t);
                });
            }
            return this.commitWrites(instances, this::createUpdateWrite, true);
        });
    }

    @Override
    public <T> Flux<T> findAll(Class<T> clazz) {
        return Flux.defer(() -> this.findAllDocuments(clazz).map(document -> this.getClassMapper().documentToEntity((Document)document, clazz)));
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass) {
        return this.count(entityClass, null);
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass, StructuredQuery.Builder queryBuilder) {
        return this.findAllDocuments(entityClass, ID_PROJECTION, queryBuilder).count();
    }

    @Override
    public <T> Mono<Long> deleteAll(Class<T> clazz) {
        return this.deleteDocumentsByName((Flux<String>)this.findAllDocuments(clazz).map(Document::getName)).count();
    }

    @Override
    public <T> Mono<Void> delete(Publisher<T> entityPublisher) {
        return this.deleteDocumentsByName((Flux<String>)Flux.from(entityPublisher).map(this::buildResourceName)).then();
    }

    @Override
    public Mono<Void> deleteById(Publisher<String> idPublisher, Class<?> entityClass) {
        return Mono.defer(() -> {
            FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
            return this.deleteDocumentsByName((Flux<String>)Flux.from((Publisher)idPublisher).map(id -> this.buildResourceName(persistentEntity, (String)id))).then();
        });
    }

    @Override
    public <T> Flux<T> execute(StructuredQuery.Builder builder, Class<T> entityType) {
        return Flux.defer(() -> this.findAllDocuments(entityType, null, builder).map(document -> this.getClassMapper().documentToEntity((Document)document, entityType)));
    }

    @Override
    public FirestoreReactiveOperations withParent(String id, Class<?> entityClass) {
        return this.withParent(this.buildResourceName(id, entityClass));
    }

    @Override
    public <T> FirestoreReactiveOperations withParent(T parent) {
        return this.withParent(this.buildResourceName(parent));
    }

    @Override
    public String buildResourceName(FirestorePersistentEntity<?> persistentEntity, String resource) {
        return this.parent + "/" + persistentEntity.collectionName() + "/" + resource;
    }

    private FirestoreReactiveOperations withParent(String resourceName) {
        FirestoreTemplate firestoreTemplate = new FirestoreTemplate(this.firestoreStub, resourceName, this.classMapper, this.mappingContext);
        firestoreTemplate.setWriteBufferSize(this.writeBufferSize);
        firestoreTemplate.setWriteBufferTimeout(this.writeBufferTimeout);
        return firestoreTemplate;
    }

    public FirestoreMappingContext getMappingContext() {
        return this.mappingContext;
    }

    private Flux<String> deleteDocumentsByName(Flux<String> documentNames) {
        return Flux.deferContextual(ctx -> {
            Optional transactionContext = ctx.getOrEmpty(TransactionContext.class);
            if (transactionContext.isPresent()) {
                ReactiveFirestoreResourceHolder holder = (ReactiveFirestoreResourceHolder)((Object)((Object)((TransactionContext)transactionContext.get()).getResources().get(this.firestoreStub)));
                List<Write> writes = holder.getWrites();
                return Flux.from((Publisher)documentNames).doOnNext(t -> writes.add(this.createDeleteWrite((String)t)));
            }
            return this.commitWrites((Publisher)documentNames, (Function)this::createDeleteWrite, false);
        });
    }

    private <T> Flux<T> commitWrites(Publisher<T> instances, Function<T, Write> converterToWrite, boolean setUpdateTime) {
        return Flux.from(instances).bufferTimeout(this.writeBufferSize, this.writeBufferTimeout).flatMap(batch -> {
            CommitRequest.Builder builder = CommitRequest.newBuilder().setDatabase(this.databasePath);
            batch.forEach(e -> builder.addWrites((Write)converterToWrite.apply(e)));
            return ObservableReactiveUtil.unaryCall(obs -> this.firestoreStub.commit(builder.build(), obs)).flatMapMany(response -> {
                if (setUpdateTime) {
                    for (int i = 0; i < batch.size(); ++i) {
                        this.getClassMapper().setUpdateTime(batch.get(i), Timestamp.fromProto((com.google.protobuf.Timestamp)response.getWriteResults(i).getUpdateTime()));
                    }
                }
                return Flux.fromIterable((Iterable)batch);
            });
        });
    }

    private Write createDeleteWrite(String documentId) {
        return Write.newBuilder().setDelete(documentId).build();
    }

    private <T> Flux<Document> findAllDocuments(Class<T> clazz) {
        return this.findAllDocuments(clazz, null, null);
    }

    private <T> Flux<Document> findAllDocuments(Class<T> clazz, StructuredQuery.Projection projection, StructuredQuery.Builder queryBuilder) {
        return Flux.deferContextual(ctx -> {
            FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(clazz);
            StructuredQuery.Builder builder = queryBuilder != null ? queryBuilder.clone() : StructuredQuery.newBuilder();
            builder.addFrom(StructuredQuery.CollectionSelector.newBuilder().setCollectionId(persistentEntity.collectionName()).build());
            if (projection != null) {
                builder.setSelect(projection);
            }
            RunQueryRequest.Builder requestBuilder = RunQueryRequest.newBuilder().setParent(this.parent).setStructuredQuery(builder.build());
            this.doIfTransaction((ContextView)ctx, resourceHolder -> requestBuilder.setTransaction(resourceHolder.getTransactionId()));
            return ObservableReactiveUtil.streamingCall(obs -> this.firestoreStub.runQuery(requestBuilder.build(), obs)).filter(RunQueryResponse::hasDocument).map(RunQueryResponse::getDocument);
        });
    }

    private Mono<Document> getDocument(String id, Class clazz, DocumentMask documentMask) {
        return Mono.deferContextual(ctx -> {
            FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(clazz);
            GetDocumentRequest.Builder builder = GetDocumentRequest.newBuilder().setName(this.buildResourceName(persistentEntity, id));
            this.doIfTransaction((ContextView)ctx, holder -> builder.setTransaction(holder.getTransactionId()));
            if (documentMask != null) {
                builder.setMask(documentMask);
            }
            return ObservableReactiveUtil.unaryCall(obs -> this.firestoreStub.getDocument(builder.build(), obs)).onErrorResume(throwable -> throwable.getMessage().startsWith(NOT_FOUND_DOCUMENT_MESSAGE), throwable -> Mono.empty());
        });
    }

    private void doIfTransaction(ContextView ctx, Consumer<ReactiveFirestoreResourceHolder> holderConsumer) {
        Optional transactionContext = ctx.getOrEmpty(TransactionContext.class);
        transactionContext.ifPresent(transactionCtx -> {
            ReactiveFirestoreResourceHolder holder = (ReactiveFirestoreResourceHolder)((Object)((Object)transactionCtx.getResources().get(this.firestoreStub)));
            if (!holder.getWrites().isEmpty()) {
                throw new FirestoreDataException("Read operations are only allowed before write operations in a transaction");
            }
            holderConsumer.accept(holder);
        });
    }

    private <T> Write createUpdateWrite(T entity) {
        Write.Builder builder = Write.newBuilder();
        if (this.getIdValue(entity) == null) {
            builder.setCurrentDocument(Precondition.newBuilder().setExists(false).build());
        }
        String resourceName = this.buildResourceName(entity);
        Document document = this.getClassMapper().entityToDocument(entity, resourceName);
        FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        FirestorePersistentProperty updateTimeProperty = Objects.requireNonNull(persistentEntity).getUpdateTimeProperty();
        if (updateTimeProperty != null && Objects.requireNonNull((UpdateTime)updateTimeProperty.findAnnotation(UpdateTime.class)).version()) {
            Object version = persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)updateTimeProperty);
            if (version != null) {
                builder.setCurrentDocument(Precondition.newBuilder().setUpdateTime(((Timestamp)version).toProto()).build());
            } else {
                builder.setCurrentDocument(Precondition.newBuilder().setExists(false).build());
            }
        }
        return builder.setUpdate(document).build();
    }

    private <T> String buildResourceName(String entityId, Class<T> entityClass) {
        FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entityClass);
        if (persistentEntity == null) {
            throw new IllegalArgumentException(entityClass.toString() + " is not a valid Firestore entity class.");
        }
        return this.buildResourceName(persistentEntity, entityId);
    }

    private <T> String buildResourceName(T entity) {
        FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        if (persistentEntity == null) {
            throw new IllegalArgumentException(entity.getClass().toString() + " is not a valid Firestore entity class.");
        }
        FirestorePersistentProperty idProperty = persistentEntity.getIdPropertyOrFail();
        Object idVal = persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProperty);
        if (idVal == null) {
            idVal = Internal.autoId();
            persistentEntity.getPropertyAccessor(entity).setProperty((PersistentProperty)idProperty, idVal);
        }
        return this.buildResourceName(persistentEntity, idVal.toString());
    }

    private Object getIdValue(Object entity) {
        FirestorePersistentEntity persistentEntity = (FirestorePersistentEntity)this.mappingContext.getPersistentEntity(entity.getClass());
        Assert.notNull((Object)persistentEntity, (String)("Persistent entity cannot be null: " + entity.getClass()));
        FirestorePersistentProperty idProperty = persistentEntity.getIdPropertyOrFail();
        return persistentEntity.getPropertyAccessor(entity).getProperty((PersistentProperty)idProperty);
    }

    public FirestoreClassMapper getClassMapper() {
        return this.classMapper;
    }
}

