/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.firestore.repository.support;

import com.google.cloud.spring.data.firestore.FirestoreTemplate;
import com.google.cloud.spring.data.firestore.SimpleFirestoreReactiveRepository;
import com.google.cloud.spring.data.firestore.mapping.FirestoreMappingContext;
import com.google.cloud.spring.data.firestore.mapping.FirestorePersistentEntity;
import com.google.cloud.spring.data.firestore.mapping.FirestorePersistentEntityInformation;
import com.google.cloud.spring.data.firestore.repository.support.FirestoreQueryLookupStrategy;
import java.util.Optional;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.ReactiveRepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.lang.Nullable;

public class ReactiveFirestoreRepositoryFactory
extends ReactiveRepositoryFactorySupport {
    private final FirestoreTemplate firestoreTemplate;
    private final FirestoreMappingContext firestoreMappingContext;

    public ReactiveFirestoreRepositoryFactory(FirestoreTemplate firestoreTemplate, FirestoreMappingContext firestoreMappingContext) {
        this.firestoreTemplate = firestoreTemplate;
        this.firestoreMappingContext = firestoreMappingContext;
    }

    public <T, I> EntityInformation<T, I> getEntityInformation(Class<T> clazz) {
        return new FirestorePersistentEntityInformation((FirestorePersistentEntity)this.firestoreMappingContext.getPersistentEntity(clazz));
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        return this.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{this.firestoreTemplate, repositoryInformation.getDomainType()});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata repositoryMetadata) {
        return SimpleFirestoreReactiveRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new FirestoreQueryLookupStrategy(this.firestoreTemplate));
    }
}

