/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spring.data.spanner.core.SpannerMutationFactory;
import com.google.cloud.spring.data.spanner.core.admin.SpannerSchemaUtils;
import com.google.cloud.spring.data.spanner.core.convert.ConversionUtils;
import com.google.cloud.spring.data.spanner.core.convert.SpannerEntityProcessor;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerCompositeKeyProperty;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.util.Assert;

public class SpannerMutationFactoryImpl
implements SpannerMutationFactory {
    private final SpannerEntityProcessor spannerEntityProcessor;
    private final SpannerMappingContext spannerMappingContext;
    private final SpannerSchemaUtils spannerSchemaUtils;

    public SpannerMutationFactoryImpl(SpannerEntityProcessor spannerEntityProcessor, SpannerMappingContext spannerMappingContext, SpannerSchemaUtils spannerSchemaUtils) {
        Assert.notNull((Object)spannerEntityProcessor, (String)"A valid results mapper for Cloud Spanner is required.");
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid mapping context for Cloud Spanner is required.");
        Assert.notNull((Object)spannerSchemaUtils, (String)"A valid schema utils for Cloud Spanner is required.");
        this.spannerEntityProcessor = spannerEntityProcessor;
        this.spannerMappingContext = spannerMappingContext;
        this.spannerSchemaUtils = spannerSchemaUtils;
    }

    @Override
    public List<Mutation> insert(Object object) {
        return this.saveObject(Mutation.Op.INSERT, object, null);
    }

    @Override
    public List<Mutation> upsert(Object object, Set<String> includeProperties) {
        return this.saveObject(Mutation.Op.INSERT_OR_UPDATE, object, includeProperties);
    }

    @Override
    public List<Mutation> update(Object object, Set<String> includeProperties) {
        return this.saveObject(Mutation.Op.UPDATE, object, includeProperties);
    }

    @Override
    public <T> Mutation delete(Class<T> entityClass, Iterable<? extends T> entities) {
        SpannerPersistentEntity<?> persistentEntity = this.spannerMappingContext.getPersistentEntityOrFail(entityClass);
        KeySet.Builder builder = KeySet.newBuilder();
        for (T entity : entities) {
            PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(entity);
            SpannerCompositeKeyProperty idProperty = persistentEntity.getIdProperty();
            Key value = (Key)accessor.getProperty((PersistentProperty)idProperty);
            builder.addKey(value);
        }
        return this.delete(entityClass, builder.build());
    }

    @Override
    public <T> Mutation delete(T object) {
        return this.delete(object.getClass(), Collections.singletonList(object));
    }

    @Override
    public Mutation delete(Class entityClass, KeySet keys) {
        SpannerPersistentEntity<?> persistentEntity = this.spannerMappingContext.getPersistentEntityOrFail(entityClass);
        return Mutation.delete((String)persistentEntity.tableName(), (KeySet)keys);
    }

    @Override
    public Mutation delete(Class entityClass, Key key) {
        return this.delete(entityClass, KeySet.singleKey((Key)key));
    }

    private List<Mutation> saveObject(Mutation.Op op, Object object, Set<String> includeProperties) {
        SpannerPersistentEntity<?> persistentEntity = this.spannerMappingContext.getPersistentEntityOrFail(object.getClass());
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        Mutation.WriteBuilder writeBuilder = this.writeBuilder(op, persistentEntity.tableName());
        this.spannerEntityProcessor.write(object, arg_0 -> ((Mutation.WriteBuilder)writeBuilder).set(arg_0), includeProperties);
        mutations.add(writeBuilder.build());
        persistentEntity.doWithInterleavedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            Iterable kids;
            if ((includeProperties == null || includeProperties.contains(spannerPersistentProperty.getName())) && (kids = (Iterable)persistentEntity.getPropertyAccessor(object).getProperty(spannerPersistentProperty)) != null && !ConversionUtils.ignoreForWriteLazyProxy(kids)) {
                for (Object child : kids) {
                    this.verifyChildHasParentId(persistentEntity, object, (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(spannerPersistentProperty.getColumnInnerType()), child);
                    mutations.addAll(this.saveObject(op, child, includeProperties));
                }
            }
        }));
        return mutations;
    }

    private void verifyChildHasParentId(SpannerPersistentEntity parentEntity, Object parentObject, SpannerPersistentEntity childEntity, Object childObject) {
        Iterator parentKeyParts = this.spannerSchemaUtils.getKey(parentObject).getParts().iterator();
        Iterator childKeyParts = this.spannerSchemaUtils.getKey(childObject).getParts().iterator();
        int partNum = 1;
        while (parentKeyParts.hasNext()) {
            if (!childKeyParts.hasNext() || !parentKeyParts.next().equals(childKeyParts.next())) {
                throw new SpannerDataException("A child entity's common primary key parts with its parent must have the same values. Primary key component " + partNum + " does not match for entities: " + parentEntity.getType() + " " + childEntity.getType());
            }
            ++partNum;
        }
    }

    private Mutation.WriteBuilder writeBuilder(Mutation.Op op, String tableName) {
        Mutation.WriteBuilder builder;
        switch (op) {
            case INSERT: {
                builder = Mutation.newInsertBuilder((String)tableName);
                break;
            }
            case INSERT_OR_UPDATE: {
                builder = Mutation.newInsertOrUpdateBuilder((String)tableName);
                break;
            }
            case UPDATE: {
                builder = Mutation.newUpdateBuilder((String)tableName);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported save-mutation operation: " + op);
            }
        }
        return builder;
    }
}

