/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Value;
import com.google.cloud.spring.data.spanner.core.convert.CommitTimestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import org.springframework.core.convert.converter.Converter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class SpannerConverters {
    public static final Converter<java.sql.Date, Date> JAVA_SQL_TO_SPANNER_DATE_CONVERTER = new Converter<java.sql.Date, Date>(){

        @Nullable
        public Date convert(java.sql.Date date) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            return Date.fromYearMonthDay((int)cal.get(1), (int)(cal.get(2) + 1), (int)cal.get(5));
        }
    };
    public static final Converter<Date, java.sql.Date> SPANNER_TO_JAVA_SQL_DATE_CONVERTER = new Converter<Date, java.sql.Date>(){

        @Nullable
        public java.sql.Date convert(Date date) {
            Calendar cal = Calendar.getInstance();
            cal.set(date.getYear(), date.getMonth() - 1, date.getDayOfMonth());
            return new java.sql.Date(cal.getTimeInMillis());
        }
    };
    public static final Converter<LocalDate, Date> LOCAL_DATE_TIMESTAMP_CONVERTER = new Converter<LocalDate, Date>(){

        @Nullable
        public Date convert(LocalDate date) {
            return Date.fromYearMonthDay((int)date.getYear(), (int)date.getMonthValue(), (int)date.getDayOfMonth());
        }
    };
    public static final Converter<Date, LocalDate> TIMESTAMP_LOCAL_DATE_CONVERTER = new Converter<Date, LocalDate>(){

        @Nullable
        public LocalDate convert(Date date) {
            return LocalDate.of(date.getYear(), date.getMonth(), date.getDayOfMonth());
        }
    };
    public static final Converter<LocalDateTime, Timestamp> LOCAL_DATE_TIME_TIMESTAMP_CONVERTER = new CommitTimestamp.CommitTimestampDecorator<LocalDateTime>(Value.COMMIT_TIMESTAMP.toSqlTimestamp().toLocalDateTime(), l -> SpannerConverters.toTimestamp(java.sql.Timestamp.valueOf(l))){};
    public static final Converter<Timestamp, LocalDateTime> TIMESTAMP_LOCAL_DATE_TIME_CONVERTER = new Converter<Timestamp, LocalDateTime>(){

        @Nullable
        public LocalDateTime convert(Timestamp timestamp) {
            java.sql.Timestamp result = (java.sql.Timestamp)SPANNER_TO_JAVA_TIMESTAMP_CONVERTER.convert((Object)timestamp);
            Assert.notNull((Object)result, (String)("Failed to convert to a non-null timestamp: " + timestamp));
            return result.toLocalDateTime();
        }
    };
    public static final Converter<java.util.Date, Timestamp> DATE_TIMESTAMP_CONVERTER = new CommitTimestamp.CommitTimestampDecorator<java.util.Date>(Value.COMMIT_TIMESTAMP.toDate(), d -> {
        long time = d.getTime();
        long secs = Math.floorDiv(time, 1000L);
        int nanos = Math.toIntExact((time - secs * 1000L) * 1000000L);
        return Timestamp.ofTimeSecondsAndNanos((long)secs, (int)nanos);
    }){};
    public static final Converter<Timestamp, java.util.Date> TIMESTAMP_DATE_CONVERTER = new Converter<Timestamp, java.util.Date>(){

        @Nullable
        public java.util.Date convert(Timestamp timestamp) {
            return timestamp.toDate();
        }
    };
    public static final Converter<Instant, Timestamp> INSTANT_TIMESTAMP_CONVERTER = new CommitTimestamp.CommitTimestampDecorator<Instant>(Instant.ofEpochSecond(Value.COMMIT_TIMESTAMP.getSeconds(), Value.COMMIT_TIMESTAMP.getNanos()), i -> Timestamp.ofTimeSecondsAndNanos((long)i.getEpochSecond(), (int)i.getNano())){};
    public static final Converter<Timestamp, Instant> TIMESTAMP_INSTANT_CONVERTER = new Converter<Timestamp, Instant>(){

        @Nullable
        public Instant convert(Timestamp timestamp) {
            return Instant.ofEpochSecond(timestamp.getSeconds(), timestamp.getNanos());
        }
    };
    public static final Converter<java.sql.Timestamp, Timestamp> JAVA_TO_SPANNER_TIMESTAMP_CONVERTER = new CommitTimestamp.CommitTimestampDecorator<java.sql.Timestamp>(Value.COMMIT_TIMESTAMP.toSqlTimestamp(), SpannerConverters::toTimestamp){};
    public static final Converter<Timestamp, java.sql.Timestamp> SPANNER_TO_JAVA_TIMESTAMP_CONVERTER = new Converter<Timestamp, java.sql.Timestamp>(){

        @Nullable
        public java.sql.Timestamp convert(Timestamp timestamp) {
            return java.sql.Timestamp.from((Instant)TIMESTAMP_INSTANT_CONVERTER.convert((Object)timestamp));
        }
    };
    public static final Converter<byte[], ByteArray> JAVA_TO_SPANNER_BYTE_ARRAY_CONVERTER = new Converter<byte[], ByteArray>(){

        @Nullable
        public ByteArray convert(byte[] bytes) {
            return ByteArray.copyFrom((byte[])bytes);
        }
    };
    public static final Converter<ByteArray, byte[]> SPANNER_TO_JAVA_BYTE_ARRAY_CONVERTER = new Converter<ByteArray, byte[]>(){

        @Nullable
        public byte[] convert(ByteArray bytes) {
            return bytes.toByteArray();
        }
    };
    public static final Collection<Converter> DEFAULT_SPANNER_WRITE_CONVERTERS = Collections.unmodifiableCollection(Arrays.asList(DATE_TIMESTAMP_CONVERTER, INSTANT_TIMESTAMP_CONVERTER, JAVA_TO_SPANNER_BYTE_ARRAY_CONVERTER, JAVA_TO_SPANNER_TIMESTAMP_CONVERTER, JAVA_SQL_TO_SPANNER_DATE_CONVERTER, LOCAL_DATE_TIMESTAMP_CONVERTER, LOCAL_DATE_TIME_TIMESTAMP_CONVERTER));
    public static final Collection<Converter> DEFAULT_SPANNER_READ_CONVERTERS = Collections.unmodifiableCollection(Arrays.asList(TIMESTAMP_DATE_CONVERTER, TIMESTAMP_INSTANT_CONVERTER, SPANNER_TO_JAVA_BYTE_ARRAY_CONVERTER, SPANNER_TO_JAVA_TIMESTAMP_CONVERTER, SPANNER_TO_JAVA_SQL_DATE_CONVERTER, TIMESTAMP_LOCAL_DATE_CONVERTER, TIMESTAMP_LOCAL_DATE_TIME_CONVERTER));

    private SpannerConverters() {
    }

    public static Timestamp toTimestamp(@NonNull java.sql.Timestamp timestamp) {
        long secs = Math.floorDiv(timestamp.getTime(), 1000L);
        return Timestamp.ofTimeSecondsAndNanos((long)secs, (int)timestamp.getNanos());
    }
}

