/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbstractStructReader;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spring.core.util.MapBuilder;
import com.google.cloud.spring.data.spanner.core.convert.SpannerTypeMapper;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.gson.Gson;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;

public class StructAccessor {
    static final Map<Class, BiFunction<Struct, String, List>> readIterableMapping = new MapBuilder().put(Boolean.class, AbstractStructReader::getBooleanList).put(Long.class, AbstractStructReader::getLongList).put(String.class, AbstractStructReader::getStringList).put(Double.class, AbstractStructReader::getDoubleList).put(Timestamp.class, AbstractStructReader::getTimestampList).put(Date.class, AbstractStructReader::getDateList).put(ByteArray.class, AbstractStructReader::getBytesList).put(BigDecimal.class, AbstractStructReader::getBigDecimalList).put(Struct.class, AbstractStructReader::getStructList).build();
    static final Map<Class, BiFunction<Struct, String, ?>> singleItemReadMethodMapping = new MapBuilder().put(Boolean.class, AbstractStructReader::getBoolean).put(Long.class, AbstractStructReader::getLong).put(Long.TYPE, AbstractStructReader::getLong).put(String.class, AbstractStructReader::getString).put(Double.class, AbstractStructReader::getDouble).put(Double.TYPE, AbstractStructReader::getDouble).put(Timestamp.class, AbstractStructReader::getTimestamp).put(Date.class, AbstractStructReader::getDate).put(BigDecimal.class, AbstractStructReader::getBigDecimal).put(ByteArray.class, AbstractStructReader::getBytes).put(double[].class, AbstractStructReader::getDoubleArray).put(long[].class, AbstractStructReader::getLongArray).put(boolean[].class, AbstractStructReader::getBooleanArray).put(Struct.class, Struct::getStruct).build();
    static final Map<Class, BiFunction<Struct, Integer, ?>> singleItemReadMethodMappingIntCol = new MapBuilder().put(Boolean.class, AbstractStructReader::getBoolean).put(Long.class, AbstractStructReader::getLong).put(Long.TYPE, AbstractStructReader::getLong).put(String.class, AbstractStructReader::getString).put(Double.class, AbstractStructReader::getDouble).put(Double.TYPE, AbstractStructReader::getDouble).put(Timestamp.class, AbstractStructReader::getTimestamp).put(Date.class, AbstractStructReader::getDate).put(BigDecimal.class, AbstractStructReader::getBigDecimal).put(ByteArray.class, AbstractStructReader::getBytes).put(double[].class, AbstractStructReader::getDoubleArray).put(long[].class, AbstractStructReader::getLongArray).put(boolean[].class, AbstractStructReader::getBooleanArray).put(Struct.class, Struct::getStruct).build();
    private Struct struct;
    private Set<String> columnNamesIndex;
    private static final Gson gson = new Gson();

    public StructAccessor(Struct struct) {
        this.struct = struct;
        this.columnNamesIndex = this.indexColumnNames();
    }

    Object getSingleValue(String colName) {
        Type colType = this.struct.getColumnType(colName);
        Class sourceType = this.getSingleItemTypeCode(colType);
        BiFunction<Struct, String, ?> readFunction = singleItemReadMethodMapping.get(sourceType);
        if (readFunction == null) {
            return null;
        }
        return readFunction.apply(this.struct, colName);
    }

    public Object getSingleValue(int colIndex) {
        Type colType = this.struct.getColumnType(colIndex);
        Class sourceType = this.getSingleItemTypeCode(colType);
        BiFunction<Struct, Integer, ?> readFunction = singleItemReadMethodMappingIntCol.get(sourceType);
        if (readFunction == null) {
            return null;
        }
        return readFunction.apply(this.struct, colIndex);
    }

    List getListValue(String colName) {
        if (this.struct.getColumnType(colName).getCode() != Type.Code.ARRAY) {
            throw new SpannerDataException("Column is not an ARRAY type: " + colName);
        }
        Type.Code innerTypeCode = this.struct.getColumnType(colName).getArrayElementType().getCode();
        Class clazz = SpannerTypeMapper.getSimpleJavaClassFor(innerTypeCode);
        BiFunction<Struct, String, List> readMethod = readIterableMapping.get(clazz);
        return readMethod.apply(this.struct, colName);
    }

    boolean hasColumn(String columnName) {
        return this.columnNamesIndex.contains(columnName);
    }

    boolean isNull(String columnName) {
        return this.struct.isNull(columnName);
    }

    private Set<String> indexColumnNames() {
        HashSet<String> cols = new HashSet<String>();
        for (Type.StructField f : this.struct.getType().getStructFields()) {
            cols.add(f.getName());
        }
        return cols;
    }

    private Class getSingleItemTypeCode(Type colType) {
        Type.Code code = colType.getCode();
        return code.equals((Object)Type.Code.ARRAY) ? SpannerTypeMapper.getArrayJavaClassFor(colType.getArrayElementType().getCode()) : SpannerTypeMapper.getSimpleJavaClassFor(code);
    }

    <T> T getSingleJsonValue(String colName, Class<T> colType) {
        if (this.struct.isNull(colName)) {
            return null;
        }
        String jsonString = this.struct.getJson(colName);
        return (T)gson.fromJson(jsonString, colType);
    }

    public <T> T getSingleJsonValue(int colIndex, Class<T> colType) {
        if (this.struct.getColumnType(colIndex).getCode() != Type.Code.JSON) {
            throw new SpannerDataException("Column of index " + colIndex + " not an JSON type.");
        }
        if (this.struct.isNull(colIndex)) {
            return null;
        }
        String jsonString = this.struct.getJson(colIndex);
        return (T)gson.fromJson(jsonString, colType);
    }
}

