/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.repository.query;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spring.data.spanner.core.SpannerPageableQueryOptions;
import com.google.cloud.spring.data.spanner.core.SpannerTemplate;
import com.google.cloud.spring.data.spanner.core.convert.ConversionUtils;
import com.google.cloud.spring.data.spanner.core.convert.ConverterAwareMappingSpannerEntityWriter;
import com.google.cloud.spring.data.spanner.core.convert.SpannerCustomConverter;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import com.google.cloud.spring.data.spanner.repository.query.SqlStringAndPlaceholders;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.StringUtils;

public final class SpannerStatementQueryExecutor {
    private static final String LIMIT = " LIMIT ";
    private static final String WHERE = " WHERE ";
    private static final String AND = " AND ";
    private static final String LOWER_LHS = "LOWER(";

    private SpannerStatementQueryExecutor() {
    }

    public static <T> List<T> executeQuery(Class<T> type, PartTree tree, ParameterAccessor parameterAccessor, Parameter[] queryMethodParamsMetadata, SpannerTemplate spannerTemplate, SpannerMappingContext spannerMappingContext) {
        SqlStringAndPlaceholders sqlStringAndPlaceholders = SpannerStatementQueryExecutor.buildPartTreeSqlString(tree, spannerMappingContext, type, parameterAccessor);
        Map<String, Parameter> paramMetadataMap = SpannerStatementQueryExecutor.preparePartTreeSqlTagParameterMap(queryMethodParamsMetadata, sqlStringAndPlaceholders);
        Object[] params = StreamSupport.stream(parameterAccessor.spliterator(), false).toArray();
        return spannerTemplate.query(type, SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs(sqlStringAndPlaceholders.getSql(), sqlStringAndPlaceholders.getPlaceholders(), null, spannerTemplate.getSpannerEntityProcessor().getWriteConverter(), params, paramMetadataMap), null);
    }

    private static Map<String, Parameter> preparePartTreeSqlTagParameterMap(Parameter[] paramsMetadata, SqlStringAndPlaceholders sqlStringAndPlaceholders) {
        HashMap<String, Parameter> paramMetadataMap = new HashMap<String, Parameter>();
        for (int i = 0; i < paramsMetadata.length; ++i) {
            Parameter param = paramsMetadata[i];
            if (param.getType() == Pageable.class || param.getType() == Sort.class) continue;
            paramMetadataMap.put(sqlStringAndPlaceholders.getPlaceholders().get(i), param);
        }
        return paramMetadataMap;
    }

    public static <A, T> List<A> executeQuery(Function<Struct, A> rowFunc, Class<T> type, PartTree tree, ParameterAccessor parameterAccessor, Parameter[] queryMethodParamsMetadata, SpannerTemplate spannerTemplate, SpannerMappingContext spannerMappingContext) {
        SqlStringAndPlaceholders sqlStringAndPlaceholders = SpannerStatementQueryExecutor.buildPartTreeSqlString(tree, spannerMappingContext, type, parameterAccessor);
        Map<String, Parameter> paramMetadataMap = SpannerStatementQueryExecutor.preparePartTreeSqlTagParameterMap(queryMethodParamsMetadata, sqlStringAndPlaceholders);
        Object[] params = StreamSupport.stream(parameterAccessor.spliterator(), false).toArray();
        return spannerTemplate.query(rowFunc, SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs(sqlStringAndPlaceholders.getSql(), sqlStringAndPlaceholders.getPlaceholders(), null, spannerTemplate.getSpannerEntityProcessor().getWriteConverter(), params, paramMetadataMap), null);
    }

    public static <T> String applySortingPagingQueryOptions(Class<T> entityClass, SpannerPageableQueryOptions options, String sql, SpannerMappingContext mappingContext, boolean fetchInterleaved) {
        if ((options.getSort() == null || options.getSort().isUnsorted()) && options.getLimit() == null && options.getOffset() == null && !fetchInterleaved) {
            return sql;
        }
        SpannerPersistentEntity<?> persistentEntity = mappingContext.getPersistentEntityOrFail(entityClass);
        String subquery = fetchInterleaved ? SpannerStatementQueryExecutor.getChildrenSubquery(persistentEntity, mappingContext) : "";
        String alias = subquery.isEmpty() ? "" : " " + persistentEntity.tableName();
        StringBuilder sb = SpannerStatementQueryExecutor.applySort(options.getSort(), new StringBuilder("SELECT *").append(subquery).append(" FROM (").append(sql).append(")").append(alias).append(SpannerStatementQueryExecutor.buildWhere(persistentEntity)), persistentEntity);
        if (options.getLimit() != null) {
            sb.append(LIMIT).append(options.getLimit());
        }
        if (options.getOffset() != null) {
            sb.append(" OFFSET ").append(options.getOffset());
        }
        return sb.toString();
    }

    public static String buildWhere(SpannerPersistentEntity<?> entity) {
        return entity.hasWhere() ? WHERE + entity.getWhere() : "";
    }

    public static Statement getChildrenRowsQuery(Key parentKey, SpannerPersistentProperty spannerPersistentProperty, SpannerCustomConverter writeConverter, SpannerMappingContext mappingContext) {
        Class<?> childType = spannerPersistentProperty.getColumnInnerType();
        SpannerPersistentEntity<?> persistentEntity = mappingContext.getPersistentEntityOrFail(childType);
        String whereClause = SpannerStatementQueryExecutor.getWhere(spannerPersistentProperty, persistentEntity);
        return SpannerStatementQueryExecutor.buildQuery(KeySet.singleKey((Key)parentKey), persistentEntity, writeConverter, mappingContext, whereClause);
    }

    public static <T> Statement buildQuery(KeySet keySet, SpannerPersistentEntity<T> persistentEntity, SpannerCustomConverter writeConverter, SpannerMappingContext mappingContext) {
        return SpannerStatementQueryExecutor.buildQuery(keySet, persistentEntity, writeConverter, mappingContext, persistentEntity.getWhere());
    }

    public static <T> Statement buildQuery(KeySet keySet, SpannerPersistentEntity<T> persistentEntity, SpannerCustomConverter writeConverter, SpannerMappingContext mappingContext, String whereClause) {
        return SpannerStatementQueryExecutor.buildQuery(keySet, persistentEntity, writeConverter, mappingContext, whereClause, null);
    }

    public static <T> Statement buildQuery(KeySet keySet, SpannerPersistentEntity<T> persistentEntity, SpannerCustomConverter writeConverter, SpannerMappingContext mappingContext, String whereClause, String index) {
        ArrayList<String> orParts = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        ArrayList keyParts = new ArrayList();
        int tagNum = 0;
        List<SpannerPersistentProperty> keyProperties = persistentEntity.getFlattenedPrimaryKeyProperties();
        for (Key key : keySet.getKeys()) {
            StringJoiner andJoiner = new StringJoiner(AND);
            Iterator parentKeyParts = key.getParts().iterator();
            while (parentKeyParts.hasNext()) {
                SpannerPersistentProperty keyProp = keyProperties.get(tagNum % keyProperties.size());
                String tagName = "tag" + tagNum;
                andJoiner.add(keyProp.getColumnName() + " = @" + tagName);
                tags.add(tagName);
                keyParts.add(parentKeyParts.next());
                ++tagNum;
            }
            orParts.add(andJoiner.toString());
        }
        String keyClause = orParts.stream().map(s -> "(" + s + ")").collect(Collectors.joining(" OR "));
        String condition = SpannerStatementQueryExecutor.combineWithAnd(keyClause, whereClause);
        String sb = "SELECT " + SpannerStatementQueryExecutor.getColumnsStringForSelect(persistentEntity, mappingContext, true) + " FROM " + (!StringUtils.hasLength((String)index) ? persistentEntity.tableName() : String.format("%s@{FORCE_INDEX=%s}", persistentEntity.tableName(), index)) + (condition.isEmpty() ? "" : WHERE + condition);
        return SpannerStatementQueryExecutor.buildStatementFromSqlWithArgs(sb, tags, null, writeConverter, keyParts.toArray(), null);
    }

    private static <C, P> String getChildrenStructsQuery(SpannerPersistentEntity<C> childPersistentEntity, SpannerPersistentEntity<P> parentPersistentEntity, SpannerMappingContext mappingContext, String columnName, String whereClause) {
        String tableName = childPersistentEntity.tableName();
        List<SpannerPersistentProperty> parentKeyProperties = parentPersistentEntity.getFlattenedPrimaryKeyProperties();
        String keylCause = parentKeyProperties.stream().map(keyProp -> tableName + "." + keyProp.getColumnName() + " = " + parentPersistentEntity.tableName() + "." + keyProp.getColumnName()).collect(Collectors.joining(AND));
        String condition = SpannerStatementQueryExecutor.combineWithAnd(keylCause, whereClause);
        return "ARRAY (SELECT AS STRUCT " + SpannerStatementQueryExecutor.getColumnsStringForSelect(childPersistentEntity, mappingContext, true) + " FROM " + tableName + WHERE + condition + ") AS " + columnName;
    }

    private static String combineWithAnd(String cond1, String cond2) {
        if (!StringUtils.hasLength((String)cond1)) {
            return StringUtils.hasLength((String)cond2) ? cond2 : "";
        }
        if (!StringUtils.hasLength((String)cond2)) {
            return StringUtils.hasLength((String)cond1) ? cond1 : "";
        }
        return "(" + cond1 + ") AND (" + cond2 + ")";
    }

    public static Statement buildStatementFromSqlWithArgs(String sql, List<String> tags, Function<Object, Struct> paramStructConvertFunc, SpannerCustomConverter spannerCustomConverter, Object[] params, Map<String, Parameter> queryMethodParams) {
        if (tags == null && params == null) {
            return Statement.of((String)sql);
        }
        if (tags == null || params == null || tags.size() != params.length) {
            throw new IllegalArgumentException("The number of tags does not match the number of params.");
        }
        Statement.Builder builder = Statement.newBuilder((String)sql);
        for (int i = 0; i < tags.size(); ++i) {
            SpannerStatementQueryExecutor.bindParameter((ValueBinder<Statement.Builder>)builder.bind(tags.get(i)), paramStructConvertFunc, spannerCustomConverter, params[i], queryMethodParams == null ? null : queryMethodParams.get(tags.get(i)));
        }
        return builder.build();
    }

    private static void bindParameter(ValueBinder<Statement.Builder> bind, Function<Object, Struct> paramStructConvertFunc, SpannerCustomConverter spannerCustomConverter, Object originalParam, Parameter paramMetadata) {
        Class<?> propType;
        Class<?> clazz = propType = originalParam != null ? originalParam.getClass() : paramMetadata.getType();
        if (ConversionUtils.isIterableNonByteArrayType(propType)) {
            if (!ConverterAwareMappingSpannerEntityWriter.attemptSetIterableValueOnBinder((Iterable)originalParam, bind, spannerCustomConverter, (Class)((ParameterizedType)paramMetadata.getParameterizedType()).getActualTypeArguments()[0])) {
                throw new IllegalArgumentException("Could not convert to an ARRAY of compatible type: " + paramMetadata);
            }
            return;
        }
        if (!ConverterAwareMappingSpannerEntityWriter.attemptBindSingleValue(originalParam, propType, bind, spannerCustomConverter)) {
            if (paramStructConvertFunc == null) {
                throw new IllegalArgumentException("Param: " + originalParam + " is not a supported type: " + propType);
            }
            try {
                Object obj = ConverterAwareMappingSpannerEntityWriter.singleItemTypeValueBinderMethodMap.get(Struct.class).apply(bind, paramStructConvertFunc.apply(originalParam));
            }
            catch (SpannerDataException ex) {
                throw new IllegalArgumentException("Param: " + originalParam + " is not a supported type: " + propType, (Throwable)((Object)ex));
            }
        }
    }

    public static String getColumnsStringForSelect(SpannerPersistentEntity<?> spannerPersistentEntity, SpannerMappingContext mappingContext, boolean fetchInterleaved) {
        String sql = String.join((CharSequence)", ", spannerPersistentEntity.columns());
        return fetchInterleaved ? sql + SpannerStatementQueryExecutor.getChildrenSubquery(spannerPersistentEntity, mappingContext) : sql;
    }

    private static String getWhere(SpannerPersistentProperty spannerPersistentProperty, SpannerPersistentEntity<?> childPersistentEntity) {
        return spannerPersistentProperty.hasWhere() ? spannerPersistentProperty.getWhere() : childPersistentEntity.getWhere();
    }

    private static String getChildrenSubquery(SpannerPersistentEntity<?> spannerPersistentEntity, SpannerMappingContext mappingContext) {
        StringJoiner joiner = new StringJoiner(", ", ", ", "").setEmptyValue("");
        spannerPersistentEntity.doWithInterleavedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            if (spannerPersistentProperty.isEagerInterleaved()) {
                Class<?> childType = spannerPersistentProperty.getColumnInnerType();
                SpannerPersistentEntity<?> childPersistentEntity = mappingContext.getPersistentEntityOrFail(childType);
                joiner.add(SpannerStatementQueryExecutor.getChildrenStructsQuery(childPersistentEntity, spannerPersistentEntity, mappingContext, spannerPersistentProperty.getColumnName(), SpannerStatementQueryExecutor.getWhere(spannerPersistentProperty, childPersistentEntity)));
            }
        }));
        return joiner.toString();
    }

    private static SqlStringAndPlaceholders buildPartTreeSqlString(PartTree tree, SpannerMappingContext spannerMappingContext, Class type, ParameterAccessor params) {
        String selectSql;
        SpannerPersistentEntity<?> persistentEntity = spannerMappingContext.getPersistentEntityOrFail(type);
        ArrayList<String> tags = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        SpannerStatementQueryExecutor.buildSelect(persistentEntity, tree, stringBuilder, spannerMappingContext);
        SpannerStatementQueryExecutor.buildFrom(persistentEntity, stringBuilder);
        SpannerStatementQueryExecutor.buildWhere(tree, persistentEntity, tags, stringBuilder);
        SpannerStatementQueryExecutor.applySort(params.getSort().isSorted() ? params.getSort() : tree.getSort(), stringBuilder, persistentEntity);
        SpannerStatementQueryExecutor.buildLimit(tree, stringBuilder, params.getPageable());
        String finalSql = selectSql = stringBuilder.toString();
        if (tree.isCountProjection()) {
            finalSql = "SELECT COUNT(1) FROM (" + selectSql + ")";
        } else if (tree.isExistsProjection()) {
            finalSql = "SELECT EXISTS(" + selectSql + ")";
        }
        return new SqlStringAndPlaceholders(finalSql, tags);
    }

    private static void buildSelect(SpannerPersistentEntity<?> spannerPersistentEntity, PartTree tree, StringBuilder stringBuilder, SpannerMappingContext mappingContext) {
        stringBuilder.append("SELECT ").append(tree.isDistinct() ? "DISTINCT " : "").append(SpannerStatementQueryExecutor.getColumnsStringForSelect(spannerPersistentEntity, mappingContext, !tree.isExistsProjection() && !tree.isCountProjection())).append(" ");
    }

    private static void buildFrom(SpannerPersistentEntity<?> persistentEntity, StringBuilder stringBuilder) {
        stringBuilder.append("FROM ").append(persistentEntity.tableName()).append(" ");
    }

    public static StringBuilder applySort(Sort sort, StringBuilder sql, SpannerPersistentEntity<?> persistentEntity) {
        if (sort == null || sort.isUnsorted()) {
            return sql;
        }
        sql.append(" ORDER BY ");
        StringJoiner sj = new StringJoiner(" , ");
        sort.iterator().forEachRemaining(o -> {
            SpannerPersistentProperty property = (SpannerPersistentProperty)persistentEntity.getPersistentProperty(o.getProperty());
            String sortedPropertyName = property != null ? property.getColumnName() : o.getProperty();
            String sortedProperty = o.isIgnoreCase() ? LOWER_LHS + sortedPropertyName + ")" : sortedPropertyName;
            sj.add(sortedProperty + (o.isAscending() ? " ASC" : " DESC"));
        });
        return sql.append(sj);
    }

    private static void buildWhere(PartTree tree, SpannerPersistentEntity<?> persistentEntity, List<String> tags, StringBuilder stringBuilder) {
        if (tree.hasPredicate()) {
            stringBuilder.append("WHERE ");
            StringJoiner orStrings = new StringJoiner(" OR ");
            tree.iterator().forEachRemaining(orPart -> {
                String orString = "( ";
                StringJoiner andStrings = new StringJoiner(AND);
                orPart.forEach(part -> {
                    String segment = part.getProperty().getSegment();
                    String tag = "tag" + tags.size();
                    tags.add(tag);
                    SpannerPersistentProperty spannerPersistentProperty = (SpannerPersistentProperty)persistentEntity.getPersistentProperty(segment);
                    if (spannerPersistentProperty.isEmbedded()) {
                        throw new SpannerDataException("Embedded class properties are not currently supported in query method names: " + segment);
                    }
                    String andString = spannerPersistentProperty.getColumnName();
                    String insertedTag = "@" + tag;
                    if (part.shouldIgnoreCase() == Part.IgnoreCaseType.ALWAYS) {
                        andString = LOWER_LHS + andString + ")";
                        insertedTag = LOWER_LHS + insertedTag + ")";
                    } else if (part.shouldIgnoreCase() != Part.IgnoreCaseType.NEVER) {
                        throw new SpannerDataException("Only ignore-case types ALWAYS and NEVER are supported, because the underlying table schema is not retrieved at query time to check that the column is the STRING or BYTES Cloud Spanner  type supported for ignoring case.");
                    }
                    switch (part.getType()) {
                        case LIKE: {
                            andString = andString + " LIKE " + insertedTag;
                            break;
                        }
                        case NOT_LIKE: {
                            andString = andString + " NOT LIKE " + insertedTag;
                            break;
                        }
                        case CONTAINING: {
                            andString = " REGEXP_CONTAINS(" + andString + "," + insertedTag + ") =TRUE";
                            break;
                        }
                        case NOT_CONTAINING: {
                            andString = " REGEXP_CONTAINS(" + andString + "," + insertedTag + ") =FALSE";
                            break;
                        }
                        case SIMPLE_PROPERTY: {
                            andString = andString + "=" + insertedTag;
                            break;
                        }
                        case TRUE: {
                            andString = andString + "=TRUE";
                            break;
                        }
                        case FALSE: {
                            andString = andString + "=FALSE";
                            break;
                        }
                        case IS_NULL: {
                            andString = andString + "=NULL";
                            break;
                        }
                        case LESS_THAN: {
                            andString = andString + "<" + insertedTag;
                            break;
                        }
                        case IS_NOT_NULL: {
                            andString = andString + "<>NULL";
                            break;
                        }
                        case LESS_THAN_EQUAL: {
                            andString = andString + "<=" + insertedTag;
                            break;
                        }
                        case GREATER_THAN: {
                            andString = andString + ">" + insertedTag;
                            break;
                        }
                        case GREATER_THAN_EQUAL: {
                            andString = andString + ">=" + insertedTag;
                            break;
                        }
                        case IN: {
                            andString = andString + " IN UNNEST(" + insertedTag + ")";
                            break;
                        }
                        case NOT_IN: {
                            andString = andString + " NOT IN UNNEST(" + insertedTag + ")";
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("The statement type: " + part.getType() + " is not supported.");
                        }
                    }
                    andStrings.add(andString);
                });
                orString = orString + andStrings.toString();
                orString = orString + " )";
                orStrings.add(orString);
            });
            stringBuilder.append(SpannerStatementQueryExecutor.combineWithAnd(orStrings.toString(), persistentEntity.getWhere()));
        }
    }

    private static void buildLimit(PartTree tree, StringBuilder stringBuilder, Pageable pageable) {
        if (tree.isExistsProjection()) {
            stringBuilder.append(" LIMIT 1");
        } else if (pageable.isPaged()) {
            stringBuilder.append(LIMIT).append(pageable.getPageSize()).append(" OFFSET ").append(pageable.getOffset());
        } else if (tree.isLimiting()) {
            stringBuilder.append(LIMIT).append(tree.getMaxResults());
        }
    }
}

