/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.repository.support;

import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spring.data.spanner.core.SpannerOperations;
import com.google.cloud.spring.data.spanner.core.SpannerPageableQueryOptions;
import com.google.cloud.spring.data.spanner.core.SpannerTemplate;
import com.google.cloud.spring.data.spanner.repository.SpannerRepository;
import java.util.Optional;
import java.util.function.Function;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.util.Assert;

public class SimpleSpannerRepository<T, I>
implements SpannerRepository<T, I> {
    private static final String NON_NULL_ID_REQUIRED = "A non-null ID is required.";
    private final SpannerTemplate spannerTemplate;
    private final Class<T> entityType;

    public SimpleSpannerRepository(SpannerTemplate spannerTemplate, Class<T> entityType) {
        Assert.notNull((Object)spannerTemplate, (String)"A valid SpannerTemplate object is required.");
        Assert.notNull(entityType, (String)"A valid entity type is required.");
        this.spannerTemplate = spannerTemplate;
        this.entityType = entityType;
    }

    @Override
    public SpannerOperations getSpannerTemplate() {
        return this.spannerTemplate;
    }

    @Override
    public <A> A performReadOnlyTransaction(Function<SpannerRepository<T, I>, A> operations) {
        return (A)this.spannerTemplate.performReadOnlyTransaction(transactionSpannerOperations -> operations.apply(new SimpleSpannerRepository<T, I>((SpannerTemplate)transactionSpannerOperations, this.entityType)), null);
    }

    @Override
    public <A> A performReadWriteTransaction(Function<SpannerRepository<T, I>, A> operations) {
        return (A)this.spannerTemplate.performReadWriteTransaction((SpannerTemplate transactionSpannerOperations) -> operations.apply(new SimpleSpannerRepository<T, I>((SpannerTemplate)transactionSpannerOperations, this.entityType)));
    }

    public <S extends T> S save(S entity) {
        Assert.notNull(entity, (String)"A non-null entity is required for saving.");
        this.spannerTemplate.upsert(entity);
        return entity;
    }

    public <S extends T> Iterable<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"A non-null list of entities is required for saving.");
        this.spannerTemplate.upsertAll(entities);
        return entities;
    }

    public Optional<T> findById(I id) {
        Assert.notNull(id, (String)NON_NULL_ID_REQUIRED);
        T result = this.spannerTemplate.read(this.entityType, this.toKey(id));
        return Optional.ofNullable(result);
    }

    public boolean existsById(I id) {
        Assert.notNull(id, (String)NON_NULL_ID_REQUIRED);
        return this.spannerTemplate.existsById(this.entityType, this.toKey(id));
    }

    public Iterable<T> findAll() {
        return this.spannerTemplate.readAll(this.entityType);
    }

    public Iterable<T> findAllById(Iterable<I> ids) {
        KeySet.Builder builder = KeySet.newBuilder();
        for (I id : ids) {
            builder.addKey(this.toKey(id));
        }
        return this.spannerTemplate.read(this.entityType, builder.build());
    }

    public long count() {
        return this.spannerTemplate.count(this.entityType);
    }

    public void deleteById(Object id) {
        Assert.notNull((Object)id, (String)NON_NULL_ID_REQUIRED);
        this.spannerTemplate.delete(this.entityType, this.toKey(id));
    }

    public void delete(Object entity) {
        Assert.notNull((Object)entity, (String)"A non-null entity is required.");
        this.spannerTemplate.delete(entity);
    }

    public void deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"A non-null list of entities is required.");
        this.spannerTemplate.deleteAll(entities);
    }

    public void deleteAll() {
        this.spannerTemplate.delete(this.entityType, KeySet.all());
    }

    public Iterable<T> findAll(Sort sort) {
        return this.spannerTemplate.queryAll(this.entityType, new SpannerPageableQueryOptions().setSort(sort));
    }

    public Page<T> findAll(Pageable pageable) {
        return new PageImpl(this.spannerTemplate.queryAll(this.entityType, new SpannerPageableQueryOptions().setLimit(pageable.getPageSize()).setOffset(pageable.getOffset()).setSort(pageable.getSort())), pageable, this.spannerTemplate.count(this.entityType));
    }

    public void deleteAllById(Iterable<? extends I> ids) {
        KeySet.Builder builder = KeySet.newBuilder();
        for (I id : ids) {
            builder.addKey(this.toKey(id));
        }
        this.spannerTemplate.delete(this.entityType, builder.build());
    }

    private Key toKey(Object id) {
        return this.spannerTemplate.getSpannerEntityProcessor().convertToKey(id);
    }
}

