/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.repository.support;

import com.google.cloud.spring.data.spanner.core.SpannerTemplate;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntityInformation;
import com.google.cloud.spring.data.spanner.repository.query.SpannerQueryLookupStrategy;
import com.google.cloud.spring.data.spanner.repository.support.SimpleSpannerRepository;
import java.util.Optional;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.expression.BeanFactoryAccessor;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.Parameters;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.spel.ExpressionDependencies;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class SpannerRepositoryFactory
extends RepositoryFactorySupport
implements ApplicationContextAware {
    private static final SpelExpressionParser EXPRESSION_PARSER = new SpelExpressionParser();
    private final SpannerMappingContext spannerMappingContext;
    private final SpannerTemplate spannerTemplate;
    private ApplicationContext applicationContext;

    SpannerRepositoryFactory(SpannerMappingContext spannerMappingContext, SpannerTemplate spannerTemplate) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid SpannerMappingContext is required.");
        Assert.notNull((Object)spannerTemplate, (String)"A valid SpannerTemplate object is required.");
        this.spannerMappingContext = spannerMappingContext;
        this.spannerTemplate = spannerTemplate;
    }

    public <T, I> EntityInformation<T, I> getEntityInformation(Class<T> domainClass) {
        SpannerPersistentEntity entity = (SpannerPersistentEntity)this.spannerMappingContext.getPersistentEntity(domainClass);
        if (entity == null) {
            throw new MappingException(String.format("Could not lookup mapping metadata for domain class %s!", domainClass.getName()));
        }
        return new SpannerPersistentEntityInformation(entity);
    }

    protected Object getTargetRepository(RepositoryInformation metadata) {
        return this.getTargetRepositoryViaReflection(metadata, new Object[]{this.spannerTemplate, metadata.getDomainType()});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleSpannerRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return Optional.of(new SpannerQueryLookupStrategy(this.spannerMappingContext, this.spannerTemplate, this.delegateContextProvider(evaluationContextProvider), EXPRESSION_PARSER));
    }

    private QueryMethodEvaluationContextProvider delegateContextProvider(final QueryMethodEvaluationContextProvider evaluationContextProvider) {
        return new QueryMethodEvaluationContextProvider(){

            public <T extends Parameters<?, ?>> EvaluationContext getEvaluationContext(T parameters, Object[] parameterValues) {
                StandardEvaluationContext evaluationContext = (StandardEvaluationContext)evaluationContextProvider.getEvaluationContext(parameters, parameterValues);
                evaluationContext.setRootObject((Object)SpannerRepositoryFactory.this.applicationContext);
                evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
                evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)SpannerRepositoryFactory.this.applicationContext));
                return evaluationContext;
            }

            public <T extends Parameters<?, ?>> EvaluationContext getEvaluationContext(T parameters, Object[] parameterValues, ExpressionDependencies expressionDependencies) {
                StandardEvaluationContext evaluationContext = (StandardEvaluationContext)evaluationContextProvider.getEvaluationContext(parameters, parameterValues, expressionDependencies);
                evaluationContext.setRootObject((Object)SpannerRepositoryFactory.this.applicationContext);
                evaluationContext.addPropertyAccessor((PropertyAccessor)new BeanFactoryAccessor());
                evaluationContext.setBeanResolver((BeanResolver)new BeanFactoryResolver((BeanFactory)SpannerRepositoryFactory.this.applicationContext));
                return evaluationContext;
            }
        };
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

