/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.TimestampBound;
import com.google.cloud.spring.data.spanner.core.AbstractSpannerRequestOptions;
import com.google.cloud.spring.data.spanner.core.SpannerQueryOptions;
import java.util.Set;
import org.springframework.util.Assert;

public class SpannerReadOptions
extends AbstractSpannerRequestOptions<Options.ReadOption> {
    private String index;

    public SpannerReadOptions() {
        this.requestOptionType = Options.ReadOption.class;
    }

    public SpannerReadOptions addReadOption(Options.ReadOption readOption) {
        Assert.notNull((Object)readOption, (String)"Valid read option is required!");
        this.requestOptions.add(readOption);
        return this;
    }

    public String getIndex() {
        return this.index;
    }

    public SpannerReadOptions setIndex(String index) {
        this.index = index;
        return this;
    }

    @Override
    public SpannerReadOptions setIncludeProperties(Set<String> includeProperties) {
        super.setIncludeProperties(includeProperties);
        return this;
    }

    @Override
    public SpannerReadOptions setTimestampBound(TimestampBound timestampBound) {
        super.setTimestampBound(timestampBound);
        return this;
    }

    @Override
    public SpannerReadOptions setTimestamp(Timestamp timestamp) {
        super.setTimestamp(timestamp);
        return this;
    }

    @Override
    public SpannerReadOptions setAllowPartialRead(boolean allowPartialRead) {
        super.setAllowPartialRead(allowPartialRead);
        return this;
    }

    public SpannerQueryOptions toQueryOptions() {
        SpannerQueryOptions query = new SpannerQueryOptions();
        query.setAllowPartialRead(this.isAllowPartialRead());
        query.setIncludeProperties((Set)this.getIncludeProperties());
        query.setTimestampBound(this.getTimestampBound());
        for (Options.ReadOption ro : (Options.ReadOption[])this.getOptions()) {
            if (!(ro instanceof Options.ReadAndQueryOption)) {
                throw new IllegalArgumentException(String.format("Can't convert %s to SpannerQueryOptions ", this));
            }
            query.addQueryOption((Options.QueryOption)((Options.ReadAndQueryOption)ro));
        }
        return query;
    }
}

