/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.convert;

import com.google.cloud.spring.data.spanner.core.convert.ConversionUtils;
import java.util.Collection;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.convert.CustomConversions;
import org.springframework.util.Assert;

public abstract class SpannerCustomConverter {
    private final ConfigurableConversionService conversionService;

    SpannerCustomConverter(CustomConversions customConversions, GenericConversionService conversionService) {
        Assert.notNull((Object)customConversions, (String)"Valid custom conversions are required!");
        this.conversionService = conversionService != null ? conversionService : new DefaultConversionService();
        customConversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    public boolean canConvert(Class<?> sourceType, Class<?> targetType) {
        Class boxedTargetType = ConversionUtils.boxIfNeeded(targetType);
        Class boxedSourceType = ConversionUtils.boxIfNeeded(sourceType);
        return boxedSourceType.equals(boxedTargetType) || this.conversionService.canConvert(boxedSourceType, boxedTargetType);
    }

    public <T> T convert(Object sourceValue, Class<T> targetType) {
        Class boxedTargetType = ConversionUtils.boxIfNeeded(targetType);
        if (sourceValue == null) {
            return (T)this.conversionService.convert(null, boxedTargetType);
        }
        Class boxedSourceType = ConversionUtils.boxIfNeeded(sourceValue.getClass());
        return (T)(boxedTargetType.isAssignableFrom(boxedSourceType) ? sourceValue : this.conversionService.convert(sourceValue, boxedTargetType));
    }

    static CustomConversions getCustomConversions(Collection<Converter> converters) {
        return new CustomConversions(CustomConversions.StoreConversions.NONE, converters);
    }
}

