/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.repository.config;

import com.google.cloud.spring.data.spanner.core.mapping.Table;
import com.google.cloud.spring.data.spanner.repository.SpannerRepository;
import com.google.cloud.spring.data.spanner.repository.support.SpannerRepositoryFactoryBean;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.XmlRepositoryConfigurationSource;
import org.w3c.dom.Element;

public class SpannerRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    protected String getModulePrefix() {
        return "spanner";
    }

    public String getRepositoryFactoryBeanClassName() {
        return SpannerRepositoryFactoryBean.class.getName();
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("spannerTemplate", attributes.getString("spannerTemplateRef"));
        builder.addPropertyReference("spannerMappingContext", attributes.getString("spannerMappingContextRef"));
    }

    protected Collection<Class<? extends Annotation>> getIdentifyingAnnotations() {
        return Collections.singleton(Table.class);
    }

    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(SpannerRepository.class);
    }

    public void postProcess(BeanDefinitionBuilder builder, XmlRepositoryConfigurationSource config) {
        Element element = config.getElement();
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)"spanner-template-ref", (String)"spannerTemplate");
        ParsingUtils.setPropertyReference((BeanDefinitionBuilder)builder, (Element)element, (String)"spanner-mapping-context-ref", (String)"spannerMappingContext");
    }
}

