/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.repository.query;

import com.google.cloud.spring.data.spanner.core.SpannerTemplate;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.repository.query.PartTreeSpannerQuery;
import com.google.cloud.spring.data.spanner.repository.query.Query;
import com.google.cloud.spring.data.spanner.repository.query.SpannerQueryMethod;
import com.google.cloud.spring.data.spanner.repository.query.SqlSpannerQuery;
import java.lang.reflect.Method;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class SpannerQueryLookupStrategy
implements QueryLookupStrategy {
    private final SpannerTemplate spannerTemplate;
    private final SpannerMappingContext spannerMappingContext;
    private QueryMethodEvaluationContextProvider evaluationContextProvider;
    private SpelExpressionParser expressionParser;

    public SpannerQueryLookupStrategy(SpannerMappingContext spannerMappingContext, SpannerTemplate spannerTemplate, QueryMethodEvaluationContextProvider evaluationContextProvider, SpelExpressionParser expressionParser) {
        Assert.notNull((Object)((Object)spannerMappingContext), (String)"A valid SpannerMappingContext is required.");
        Assert.notNull((Object)spannerTemplate, (String)"A valid SpannerTemplate is required.");
        Assert.notNull((Object)evaluationContextProvider, (String)"A valid EvaluationContextProvider is required.");
        Assert.notNull((Object)expressionParser, (String)"A valid SpelExpressionParser is required.");
        this.spannerMappingContext = spannerMappingContext;
        this.evaluationContextProvider = evaluationContextProvider;
        this.spannerTemplate = spannerTemplate;
        this.expressionParser = expressionParser;
    }

    Class<?> getEntityType(QueryMethod queryMethod) {
        return queryMethod.getResultProcessor().getReturnedType().getDomainType();
    }

    SpannerQueryMethod createQueryMethod(Method method, RepositoryMetadata metadata, ProjectionFactory factory) {
        return new SpannerQueryMethod(method, metadata, factory);
    }

    public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory factory, NamedQueries namedQueries) {
        boolean isDml;
        SpannerQueryMethod queryMethod = this.createQueryMethod(method, metadata, factory);
        Class<?> entityType = this.getEntityType(queryMethod);
        Query queryAnnotation = queryMethod.getQueryAnnotation();
        boolean bl = isDml = queryAnnotation != null && queryAnnotation.dmlStatement();
        if (queryAnnotation != null && queryMethod.hasAnnotatedQuery()) {
            return this.createSqlSpannerQuery(entityType, queryMethod, queryAnnotation.value(), isDml);
        }
        if (namedQueries.hasQuery(queryMethod.getNamedQueryName())) {
            String sql = namedQueries.getQuery(queryMethod.getNamedQueryName());
            return this.createSqlSpannerQuery(entityType, queryMethod, sql, isDml);
        }
        return this.createPartTreeSpannerQuery(entityType, queryMethod);
    }

    <T> SqlSpannerQuery<T> createSqlSpannerQuery(Class<T> entityType, SpannerQueryMethod queryMethod, String sql, boolean isDml) {
        return new SqlSpannerQuery<T>(entityType, queryMethod, this.spannerTemplate, sql, this.evaluationContextProvider, this.expressionParser, this.spannerMappingContext, isDml);
    }

    <T> PartTreeSpannerQuery<T> createPartTreeSpannerQuery(Class<T> entityType, SpannerQueryMethod queryMethod) {
        return new PartTreeSpannerQuery<T>(entityType, queryMethod, this.spannerTemplate, this.spannerMappingContext);
    }
}

