/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.repository.query;

import com.google.cloud.spring.data.spanner.repository.query.Query;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class SpannerQueryMethod
extends QueryMethod {
    private final Method queryMethod;

    public SpannerQueryMethod(Method queryMethod, RepositoryMetadata metadata, ProjectionFactory factory) {
        super(queryMethod, metadata, factory);
        this.queryMethod = queryMethod;
    }

    public boolean hasAnnotatedQuery() {
        return this.findAnnotatedQuery().isPresent();
    }

    private Optional<String> findAnnotatedQuery() {
        return Optional.ofNullable(this.getQueryAnnotation()).map(AnnotationUtils::getValue).map(String.class::cast).filter(StringUtils::hasText);
    }

    Method getQueryMethod() {
        return this.queryMethod;
    }

    @Nullable
    Query getQueryAnnotation() {
        return (Query)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)this.queryMethod, Query.class);
    }
}

