/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.data.spanner.core.convert;

import com.google.cloud.ByteArray;
import com.google.cloud.Date;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Interval;
import com.google.cloud.spanner.Key;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.Type;
import com.google.cloud.spanner.Value;
import com.google.cloud.spanner.ValueBinder;
import com.google.cloud.spring.data.spanner.core.convert.ConversionUtils;
import com.google.cloud.spring.data.spanner.core.convert.MultipleValueBinder;
import com.google.cloud.spring.data.spanner.core.convert.SpannerCustomConverter;
import com.google.cloud.spring.data.spanner.core.convert.SpannerEntityWriter;
import com.google.cloud.spring.data.spanner.core.convert.SpannerTypeMapper;
import com.google.cloud.spring.data.spanner.core.convert.SpannerWriteConverter;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerDataException;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerMappingContext;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentEntity;
import com.google.cloud.spring.data.spanner.core.mapping.SpannerPersistentProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.PersistentPropertyAccessor;
import org.springframework.data.mapping.PropertyHandler;
import org.springframework.util.Assert;

public class ConverterAwareMappingSpannerEntityWriter
implements SpannerEntityWriter {
    private static final Set<Class> SPANNER_KEY_COMPATIBLE_TYPES = Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(Boolean.class, Integer.class, Long.class, Float.class, Double.class, String.class, ByteArray.class, Timestamp.class, Date.class, BigDecimal.class, UUID.class)));
    public static final Map<Class<?>, BiFunction<ValueBinder, ?, ?>> singleItemTypeValueBinderMethodMap;
    static final Map<Class<?>, BiConsumer<ValueBinder<?>, Iterable>> iterablePropertyTypeToMethodMap;
    private final SpannerMappingContext spannerMappingContext;
    private final SpannerWriteConverter writeConverter;

    private static Map<Class<?>, BiConsumer<ValueBinder<?>, Iterable>> createIterableTypeMapping() {
        LinkedHashMap<Class<UUID>, BiConsumer<ValueBinder, Iterable>> map = new LinkedHashMap<Class<UUID>, BiConsumer<ValueBinder, Iterable>>();
        map.put(Boolean.class, ValueBinder::toBoolArray);
        map.put(Long.class, ValueBinder::toInt64Array);
        map.put(Double.class, ValueBinder::toFloat64Array);
        map.put(Float.class, ValueBinder::toFloat32Array);
        map.put(BigDecimal.class, ValueBinder::toNumericArray);
        map.put(Timestamp.class, ValueBinder::toTimestampArray);
        map.put(Date.class, ValueBinder::toDateArray);
        map.put(ByteArray.class, ValueBinder::toBytesArray);
        map.put(String.class, ValueBinder::toStringArray);
        map.put(Interval.class, ValueBinder::toIntervalArray);
        map.put(UUID.class, ValueBinder::toUuidArray);
        return Collections.unmodifiableMap(map);
    }

    ConverterAwareMappingSpannerEntityWriter(SpannerMappingContext spannerMappingContext, SpannerWriteConverter writeConverter) {
        this.spannerMappingContext = spannerMappingContext;
        this.writeConverter = writeConverter;
    }

    public static Class<?> findFirstCompatibleSpannerSingleItemNativeType(Predicate<Class> testFunc) {
        return singleItemTypeValueBinderMethodMap.keySet().stream().filter(testFunc).findFirst().orElse(null);
    }

    public static Class<?> findFirstCompatibleSpannerMultipleItemNativeType(Predicate<Class> testFunc) {
        return iterablePropertyTypeToMethodMap.keySet().stream().filter(testFunc).findFirst().orElse(null);
    }

    public void write(Object source, MultipleValueBinder sink) {
        this.write(source, sink, null);
    }

    @Override
    public void write(Object source, MultipleValueBinder sink, Set<String> includeColumns) {
        boolean writeAllColumns = includeColumns == null;
        SpannerPersistentEntity<?> persistentEntity = this.spannerMappingContext.getPersistentEntityOrFail(source.getClass());
        PersistentPropertyAccessor accessor = persistentEntity.getPropertyAccessor(source);
        persistentEntity.doWithColumnBackedProperties((PropertyHandler<SpannerPersistentProperty>)((PropertyHandler)spannerPersistentProperty -> {
            if (spannerPersistentProperty.isEmbedded()) {
                Object embeddedObject = accessor.getProperty(spannerPersistentProperty);
                if (embeddedObject != null) {
                    this.write(embeddedObject, sink, includeColumns);
                }
            } else if (writeAllColumns || includeColumns.contains(spannerPersistentProperty.getColumnName())) {
                this.writeProperty(sink, accessor, (SpannerPersistentProperty)spannerPersistentProperty);
            }
        }));
    }

    @Override
    public Key convertToKey(Object key) {
        Key k;
        Assert.notNull((Object)key, (String)"Key of an entity to be written cannot be null!");
        boolean isIterable = Iterable.class.isAssignableFrom(key.getClass());
        boolean isArray = Object[].class.isAssignableFrom(key.getClass());
        if ((isIterable || isArray) && !ByteArray.class.isAssignableFrom(key.getClass())) {
            Key.Builder kb = Key.newBuilder();
            for (Object t : isArray ? Arrays.asList((Object[])key) : (List<Object>)key) {
                kb.appendObject(this.convertKeyPart(t));
            }
            k = kb.build();
            if (k.size() == 0) {
                throw new SpannerDataException("A key must have at least one component, but 0 were given.");
            }
        } else {
            k = Key.class.isAssignableFrom(key.getClass()) ? (Key)key : Key.of((Object[])new Object[]{this.convertKeyPart(key)});
        }
        return k;
    }

    @Override
    public SpannerWriteConverter getSpannerWriteConverter() {
        return this.writeConverter;
    }

    public static boolean attemptSetIterableValueOnBinder(Iterable<Object> value, ValueBinder valueBinder, SpannerCustomConverter writeConverter, Class innerType) {
        boolean valueSet;
        block2: {
            Class<?> targetType;
            valueSet = false;
            if (iterablePropertyTypeToMethodMap.containsKey(innerType)) {
                iterablePropertyTypeToMethodMap.get(innerType).accept(valueBinder, value);
                valueSet = true;
            }
            if (valueSet) break block2;
            Iterator<Class<?>> iterator = iterablePropertyTypeToMethodMap.keySet().iterator();
            while (iterator.hasNext() && !(valueSet = ConverterAwareMappingSpannerEntityWriter.attemptSetIterablePropertyWithTypeConversion(value, (ValueBinder<Mutation.WriteBuilder>)valueBinder, innerType, targetType = iterator.next(), writeConverter))) {
            }
        }
        return valueSet;
    }

    public static boolean attemptBindSingleValue(Object propertyValue, Class<?> propertyType, ValueBinder valueBinder, SpannerCustomConverter spannerCustomConverter) {
        boolean valueSet;
        block1: {
            Class<?> targetType;
            valueSet = ConverterAwareMappingSpannerEntityWriter.attemptSetSingleItemValue(propertyValue, propertyType, (ValueBinder<Mutation.WriteBuilder>)valueBinder, propertyType, spannerCustomConverter);
            if (valueSet) break block1;
            Iterator<Class<?>> iterator = singleItemTypeValueBinderMethodMap.keySet().iterator();
            while (iterator.hasNext() && !(valueSet = ConverterAwareMappingSpannerEntityWriter.attemptSetSingleItemValue(propertyValue, propertyType, (ValueBinder<Mutation.WriteBuilder>)valueBinder, targetType = iterator.next(), spannerCustomConverter))) {
            }
        }
        return valueSet;
    }

    private static boolean attemptSetIterablePropertyWithTypeConversion(Iterable<Object> value, ValueBinder<Mutation.WriteBuilder> valueBinder, Class innerType, Class<?> targetType, SpannerCustomConverter writeConverter) {
        if (writeConverter.canConvert(innerType, targetType)) {
            BiConsumer<ValueBinder<?>, Iterable> toMethod = iterablePropertyTypeToMethodMap.get(targetType);
            toMethod.accept(valueBinder, value != null ? ConversionUtils.convertIterable(value, targetType, writeConverter) : null);
            return true;
        }
        return false;
    }

    private Object convertKeyPart(Object object) {
        if (object == null || this.isValidSpannerKeyType(ConversionUtils.boxIfNeeded(object.getClass()))) {
            return object;
        }
        Class<?> compatible = ConverterAwareMappingSpannerEntityWriter.findFirstCompatibleSpannerSingleItemNativeType(spannerType -> this.isValidSpannerKeyType((Class)spannerType) && this.writeConverter.canConvert(object.getClass(), (Class<?>)spannerType));
        if (compatible == null) {
            throw new SpannerDataException("The given object type couldn't be built into a Cloud Spanner Key: " + object.getClass());
        }
        return this.writeConverter.convert(object, compatible);
    }

    private boolean isValidSpannerKeyType(Class type) {
        return SPANNER_KEY_COMPATIBLE_TYPES.contains(type);
    }

    private boolean attemptSetIterableValue(Iterable<Object> value, ValueBinder<Mutation.WriteBuilder> valueBinder, SpannerPersistentProperty spannerPersistentProperty, SpannerCustomConverter writeConverter) {
        Class innerType = ConversionUtils.boxIfNeeded(spannerPersistentProperty.getColumnInnerType());
        if (innerType == null) {
            return false;
        }
        boolean valueSet = false;
        if (spannerPersistentProperty.getAnnotatedColumnItemType() == Type.Code.JSON) {
            valueBinder.toJsonArray(this.convertIterableJsonToValue(value));
            valueSet = true;
        } else {
            valueSet = spannerPersistentProperty.getAnnotatedColumnItemType() != null ? ConverterAwareMappingSpannerEntityWriter.attemptSetIterablePropertyWithTypeConversion(value, valueBinder, innerType, SpannerTypeMapper.getSimpleJavaClassFor(spannerPersistentProperty.getAnnotatedColumnItemType()), writeConverter) : ConverterAwareMappingSpannerEntityWriter.attemptSetIterableValueOnBinder(value, valueBinder, writeConverter, innerType);
        }
        return valueSet;
    }

    private static <T> boolean attemptSetSingleItemValue(Object value, Class<?> sourceType, ValueBinder<Mutation.WriteBuilder> valueBinder, Class<T> targetType, SpannerCustomConverter writeConverter) {
        if (!writeConverter.canConvert(sourceType, targetType)) {
            return false;
        }
        Class innerType = ConversionUtils.boxIfNeeded(targetType);
        BiFunction<ValueBinder, ?, ?> toMethod = singleItemTypeValueBinderMethodMap.get(innerType);
        if (toMethod == null) {
            return false;
        }
        Object ignored = toMethod.apply(valueBinder, value != null ? (Object)writeConverter.convert(value, targetType) : null);
        return true;
    }

    private Value convertJsonToValue(Object value) {
        if (value == null) {
            return Value.json(null);
        }
        String jsonString = this.spannerMappingContext.getGson().toJson(value);
        return Value.json((String)jsonString);
    }

    private Iterable<String> convertIterableJsonToValue(Iterable<Object> value) {
        ArrayList<String> result = new ArrayList<String>();
        if (value == null) {
            return null;
        }
        value.forEach(item -> result.add(this.spannerMappingContext.getGson().toJson(item)));
        return result;
    }

    private void writeProperty(MultipleValueBinder sink, PersistentPropertyAccessor accessor, SpannerPersistentProperty property) {
        Object propertyValue = accessor.getProperty((PersistentProperty)property);
        Class propertyType = property.getType();
        ValueBinder valueBinder = sink.set(property.getColumnName());
        boolean valueSet = false;
        if (ConversionUtils.isIterableNonByteArrayType(propertyType)) {
            valueSet = this.attemptSetIterableValue((Iterable)propertyValue, (ValueBinder<Mutation.WriteBuilder>)valueBinder, property, this.writeConverter);
        } else if (property.isCommitTimestamp()) {
            valueSet = ConverterAwareMappingSpannerEntityWriter.attemptSetSingleItemValue(Value.COMMIT_TIMESTAMP, Timestamp.class, (ValueBinder<Mutation.WriteBuilder>)valueBinder, Timestamp.class, this.writeConverter);
        } else if (property.getAnnotatedColumnItemType() == Type.Code.JSON) {
            valueBinder.to(this.convertJsonToValue(propertyValue));
            valueSet = true;
        } else {
            valueSet = property.getAnnotatedColumnItemType() != null ? ConverterAwareMappingSpannerEntityWriter.attemptSetSingleItemValue(propertyValue, propertyType, (ValueBinder<Mutation.WriteBuilder>)valueBinder, SpannerTypeMapper.getSimpleJavaClassFor(property.getAnnotatedColumnItemType()), this.writeConverter) : ConverterAwareMappingSpannerEntityWriter.attemptBindSingleValue(propertyValue, propertyType, valueBinder, this.writeConverter);
        }
        if (!valueSet) {
            throw new SpannerDataException(String.format("Unsupported mapping for type: %s", propertyType));
        }
    }

    static {
        iterablePropertyTypeToMethodMap = ConverterAwareMappingSpannerEntityWriter.createIterableTypeMapping();
        LinkedHashMap<Class<Object>, BiFunction<ValueBinder, Object, Object>> map = new LinkedHashMap<Class<Object>, BiFunction<ValueBinder, Object, Object>>();
        map.put(Boolean.class, ValueBinder::to);
        map.put(Long.class, ValueBinder::to);
        map.put(Long.TYPE, ValueBinder::to);
        map.put(Double.class, ValueBinder::to);
        map.put(Double.TYPE, ValueBinder::to);
        map.put(Float.class, ValueBinder::to);
        map.put(Float.TYPE, ValueBinder::to);
        map.put(BigDecimal.class, ValueBinder::to);
        map.put(Timestamp.class, ValueBinder::to);
        map.put(Date.class, ValueBinder::to);
        map.put(ByteArray.class, ValueBinder::to);
        map.put(String.class, ValueBinder::to);
        map.put(double[].class, ValueBinder::toFloat64Array);
        map.put(float[].class, ValueBinder::toFloat32Array);
        map.put(boolean[].class, ValueBinder::toBoolArray);
        map.put(long[].class, ValueBinder::toInt64Array);
        map.put(Struct.class, ValueBinder::to);
        map.put(Interval.class, ValueBinder::to);
        map.put(UUID.class, ValueBinder::to);
        singleItemTypeValueBinderMethodMap = Collections.unmodifiableMap(map);
    }
}

