/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.logging;

import com.google.cloud.logging.LogEntry;
import com.google.cloud.logging.LoggingEnhancer;
import com.google.cloud.spring.core.DefaultGcpProjectIdProvider;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.logging.StackdriverTraceConstants;
import org.slf4j.MDC;

public class TraceIdLoggingEnhancer
implements LoggingEnhancer {
    private static final ThreadLocal<String> traceId = new ThreadLocal();
    private static final String APP_ENGINE_LABEL_NAME = "appengine.googleapis.com/trace_id";
    private GcpProjectIdProvider projectIdProvider = new DefaultGcpProjectIdProvider();
    private boolean runningOnAppEngine = System.getenv("GAE_INSTANCE") != null;

    public static void setCurrentTraceId(String id) {
        if (id == null) {
            traceId.remove();
        } else {
            traceId.set(id);
        }
    }

    public static String getCurrentTraceId() {
        return traceId.get();
    }

    public void enhanceLogEntry(LogEntry.Builder builder) {
        String traceId = MDC.get((String)"traceId");
        String spanId = MDC.get((String)"spanId");
        if (traceId == null) {
            traceId = TraceIdLoggingEnhancer.getCurrentTraceId();
        }
        if (traceId != null) {
            builder.setTrace(StackdriverTraceConstants.composeFullTraceName(this.projectIdProvider.getProjectId(), traceId));
            if (this.runningOnAppEngine) {
                builder.addLabel(APP_ENGINE_LABEL_NAME, traceId);
            }
        }
        if (spanId != null) {
            builder.setSpanId(spanId);
        }
    }
}

