/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import ch.qos.logback.core.util.Loader;
import com.google.cloud.logging.Severity;
import com.google.cloud.spring.core.DefaultGcpProjectIdProvider;
import com.google.cloud.spring.core.util.MapBuilder;
import com.google.cloud.spring.logging.JsonLoggingEventEnhancer;
import com.google.cloud.spring.logging.StackdriverErrorReportingServiceContext;
import com.google.cloud.spring.logging.StackdriverTraceConstants;
import com.google.cloud.spring.logging.TraceIdLoggingEnhancer;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.util.StringUtils;

public class StackdriverJsonLayout
extends JsonLayout {
    private static final Map<Level, String> logbackToSeverityMap = new MapBuilder().put((Object)Level.TRACE, (Object)Severity.DEBUG.name()).put((Object)Level.DEBUG, (Object)Severity.DEBUG.name()).put((Object)Level.INFO, (Object)Severity.INFO.name()).put((Object)Level.WARN, (Object)Severity.WARNING.name()).put((Object)Level.ERROR, (Object)Severity.ERROR.name()).build();
    private String projectId;
    private String traceIdMdcField = "traceId";
    private String spanIdMdcField = "spanId";
    private boolean includeTraceId;
    private boolean includeSpanId;
    private boolean includeExceptionInMessage;
    private StackdriverErrorReportingServiceContext serviceContext;
    private Map<String, Object> customJson;
    private Set<String> filteredMdcFields;
    private final List<JsonLoggingEventEnhancer> loggingEventEnhancers = new ArrayList<JsonLoggingEventEnhancer>();

    public StackdriverJsonLayout() {
        this.appendLineSeparator = true;
        this.includeExceptionInMessage = true;
        this.includeException = false;
        this.includeTraceId = true;
        this.includeSpanId = true;
        Gson formatter = new Gson();
        this.setJsonFormatter(arg_0 -> ((Gson)formatter).toJson(arg_0));
    }

    public String getProjectId() {
        return this.projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public String getTraceIdMdcField() {
        return this.traceIdMdcField;
    }

    public void setTraceIdMdcField(String traceIdMdcField) {
        this.traceIdMdcField = traceIdMdcField;
    }

    public String getSpanIdMdcField() {
        return this.spanIdMdcField;
    }

    public void setSpanIdMdcField(String spanIdMdcField) {
        this.spanIdMdcField = spanIdMdcField;
    }

    public boolean isIncludeTraceId() {
        return this.includeTraceId;
    }

    public void setIncludeTraceId(boolean includeTraceId) {
        this.includeTraceId = includeTraceId;
    }

    public boolean isIncludeSpanId() {
        return this.includeSpanId;
    }

    public void setIncludeSpanId(boolean includeSpanId) {
        this.includeSpanId = includeSpanId;
    }

    public boolean isIncludeExceptionInMessage() {
        return this.includeExceptionInMessage;
    }

    public void setIncludeExceptionInMessage(boolean includeExceptionInMessage) {
        this.includeExceptionInMessage = includeExceptionInMessage;
    }

    public void setServiceContext(StackdriverErrorReportingServiceContext serviceContext) {
        this.serviceContext = serviceContext;
    }

    public void setCustomJson(String json) {
        Gson gson = new Gson();
        this.customJson = (Map)gson.fromJson(json, Map.class);
    }

    public void addLoggingEventEnhancer(String enhancerClassName) {
        try {
            Class clz = Loader.loadClass((String)enhancerClassName.trim());
            this.loggingEventEnhancers.add((JsonLoggingEventEnhancer)clz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Cannot create object of class " + enhancerClassName, ex);
        }
    }

    public void start() {
        super.start();
        if (!StringUtils.hasText((String)this.projectId) || this.projectId.endsWith("_IS_UNDEFINED")) {
            DefaultGcpProjectIdProvider projectIdProvider = new DefaultGcpProjectIdProvider();
            this.projectId = projectIdProvider.getProjectId();
        }
        this.filteredMdcFields = new HashSet<String>(Arrays.asList(this.traceIdMdcField, this.spanIdMdcField, "X-Span-Export"));
    }

    protected Map<String, Object> toJsonMap(ILoggingEvent event) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.includeMDC) {
            HashMap shallowCopy = new HashMap(event.getMDCPropertyMap());
            shallowCopy.keySet().removeAll(this.filteredMdcFields);
            map.putAll(shallowCopy);
        }
        if (this.includeTimestamp) {
            map.put("timestampSeconds", TimeUnit.MILLISECONDS.toSeconds(event.getTimeStamp()));
            map.put("timestampNanos", TimeUnit.MILLISECONDS.toNanos(event.getTimeStamp() % 1000L));
        }
        this.add("severity", this.includeLevel, logbackToSeverityMap.getOrDefault(event.getLevel(), Severity.DEFAULT.name()), map);
        this.add("thread", this.includeThreadName, event.getThreadName(), map);
        this.add("logger", this.includeLoggerName, event.getLoggerName(), map);
        if (this.includeFormattedMessage) {
            map.put("message", this.formatMessage(event));
        }
        this.add("raw-message", this.includeMessage, event.getMessage(), map);
        this.add("context", this.includeContextName, event.getLoggerContextVO().getName(), map);
        this.addThrowableInfo("exception", this.includeException, event, map);
        this.addTraceId(event, map);
        this.add("logging.googleapis.com/spanId", this.includeSpanId, (String)event.getMDCPropertyMap().get(this.spanIdMdcField), map);
        if (this.serviceContext != null) {
            map.put("serviceContext", this.serviceContext);
        }
        if (this.customJson != null && !this.customJson.isEmpty()) {
            for (Map.Entry entry : this.customJson.entrySet()) {
                map.putIfAbsent((String)entry.getKey(), entry.getValue());
            }
        }
        this.addCustomDataToJsonMap(map, event);
        for (JsonLoggingEventEnhancer jsonLoggingEventEnhancer : this.loggingEventEnhancers) {
            jsonLoggingEventEnhancer.enhanceJsonLogEntry(map, event);
        }
        return map;
    }

    private String formatMessage(ILoggingEvent event) {
        StringBuilder message = new StringBuilder();
        message.append(event.getFormattedMessage());
        if (!this.includeExceptionInMessage) {
            return message.toString();
        }
        IThrowableProxy throwableProxy = event.getThrowableProxy();
        if (throwableProxy != null) {
            message.append(this.formatThrowable(event));
        }
        return message.toString();
    }

    private String formatThrowable(ILoggingEvent event) {
        String stackTrace = this.getThrowableProxyConverter().convert((Object)event);
        return StringUtils.hasText((String)stackTrace) ? "\n" + stackTrace : "";
    }

    protected String formatTraceId(String traceId) {
        if (traceId != null && traceId.length() == 16) {
            return "0000000000000000" + traceId;
        }
        return traceId;
    }

    private void addTraceId(ILoggingEvent event, Map<String, Object> map) {
        if (!this.includeTraceId) {
            return;
        }
        String traceId = (String)event.getMDCPropertyMap().get(this.traceIdMdcField);
        if (traceId == null) {
            traceId = TraceIdLoggingEnhancer.getCurrentTraceId();
        }
        if (StringUtils.hasText((String)traceId) && StringUtils.hasText((String)this.projectId) && !this.projectId.endsWith("_IS_UNDEFINED")) {
            traceId = StackdriverTraceConstants.composeFullTraceName(this.projectId, this.formatTraceId(traceId));
        }
        this.add("logging.googleapis.com/trace", this.includeTraceId, traceId, map);
    }
}

