/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.parametermanager;

import com.google.cloud.parametermanager.v1.ParameterVersionName;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.parametermanager.ParameterManagerPropertyUtils;
import com.google.cloud.spring.parametermanager.ParameterManagerTemplate;
import org.springframework.core.env.EnumerablePropertySource;

public class ParameterManagerPropertySource
extends EnumerablePropertySource<ParameterManagerTemplate> {
    private final GcpProjectIdProvider projectIdProvider;

    public ParameterManagerPropertySource(String propertySourceName, ParameterManagerTemplate parameterManagerTemplate, GcpProjectIdProvider projectIdProvider) {
        super(propertySourceName, (Object)parameterManagerTemplate);
        this.projectIdProvider = projectIdProvider;
    }

    public Object getProperty(String name) {
        ParameterVersionName parameterIdentifier = ParameterManagerPropertyUtils.getParameterVersionName(name, this.projectIdProvider);
        if (parameterIdentifier != null) {
            return ((ParameterManagerTemplate)this.getSource()).getRenderedParameterByteString(parameterIdentifier);
        }
        return null;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }
}

