/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.parametermanager;

import com.google.cloud.parametermanager.v1.ParameterVersionName;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import org.springframework.util.Assert;

public class ParameterManagerPropertyUtils {
    private static final String GCP_PARAMETER_PREFIX = "pm@";

    private ParameterManagerPropertyUtils() {
    }

    static ParameterVersionName getParameterVersionName(String input, GcpProjectIdProvider projectIdProvider) {
        boolean isAttemptingFullStringMatch = input.contains(":");
        if (!input.startsWith(GCP_PARAMETER_PREFIX) || isAttemptingFullStringMatch) {
            return null;
        }
        String resourcePath = input.substring(GCP_PARAMETER_PREFIX.length());
        String[] tokens = resourcePath.split("/");
        String projectId = projectIdProvider.getProjectId();
        String locationId = null;
        String parameterId = null;
        String versionId = null;
        if (tokens.length == 3) {
            locationId = tokens[0];
            parameterId = tokens[1];
            versionId = tokens[2];
        } else if (tokens.length == 4) {
            projectId = tokens[0];
            locationId = tokens[1];
            parameterId = tokens[2];
            versionId = tokens[3];
        } else if (tokens.length == 6 && tokens[0].equals("locations") && tokens[2].equals("parameters") && tokens[4].equals("versions")) {
            locationId = tokens[1];
            parameterId = tokens[3];
            versionId = tokens[5];
        } else if (tokens.length == 8 && tokens[0].equals("projects") && tokens[2].equals("locations") && tokens[4].equals("parameters") && tokens[6].equals("versions")) {
            projectId = tokens[1];
            locationId = tokens[3];
            parameterId = tokens[5];
            versionId = tokens[7];
        } else {
            throw new IllegalArgumentException("Unrecognized format for specifying a GCP Parameter Manager parameter: " + input);
        }
        Assert.hasText((String)projectId, (String)("The GCP Parameter Manager project id must not be empty: " + input));
        Assert.hasText((String)locationId, (String)("The GCP Parameter Manager location id must not be empty: " + input));
        Assert.hasText((String)parameterId, (String)("The GCP Parameter Manager parameter id must not be empty: " + input));
        Assert.hasText((String)versionId, (String)("The GCP Parameter Manager parameter version must not be empty: " + input));
        return ParameterVersionName.of((String)projectId, (String)locationId, (String)parameterId, (String)versionId);
    }
}

