/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.parametermanager;

import com.google.api.gax.rpc.NotFoundException;
import com.google.cloud.parametermanager.v1.CreateParameterRequest;
import com.google.cloud.parametermanager.v1.CreateParameterVersionRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterRequest;
import com.google.cloud.parametermanager.v1.DeleteParameterVersionRequest;
import com.google.cloud.parametermanager.v1.GetParameterVersionRequest;
import com.google.cloud.parametermanager.v1.LocationName;
import com.google.cloud.parametermanager.v1.Parameter;
import com.google.cloud.parametermanager.v1.ParameterFormat;
import com.google.cloud.parametermanager.v1.ParameterManagerClient;
import com.google.cloud.parametermanager.v1.ParameterName;
import com.google.cloud.parametermanager.v1.ParameterVersion;
import com.google.cloud.parametermanager.v1.ParameterVersionName;
import com.google.cloud.parametermanager.v1.ParameterVersionPayload;
import com.google.cloud.parametermanager.v1.UpdateParameterVersionRequest;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.parametermanager.ParameterManagerClientFactory;
import com.google.cloud.spring.parametermanager.ParameterManagerOperations;
import com.google.cloud.spring.parametermanager.ParameterManagerPropertyUtils;
import com.google.protobuf.ByteString;
import com.google.protobuf.util.FieldMaskUtil;
import javax.annotation.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterManagerTemplate
implements ParameterManagerOperations {
    public static final String GLOBAL_LOCATION = "global";
    private static final Log LOGGER = LogFactory.getLog(ParameterManagerTemplate.class);
    private final ParameterManagerClient parameterManagerClient;
    private final ParameterManagerClientFactory clientFactory;
    private final GcpProjectIdProvider projectIdProvider;
    private boolean allowDefaultParameterValue;

    public ParameterManagerTemplate(ParameterManagerClient parameterManagerClient, GcpProjectIdProvider projectIdProvider) {
        this(parameterManagerClient, null, projectIdProvider);
    }

    public ParameterManagerTemplate(ParameterManagerClientFactory clientFactory, GcpProjectIdProvider projectIdProvider) {
        this(clientFactory.getClient(GLOBAL_LOCATION), clientFactory, projectIdProvider);
    }

    private ParameterManagerTemplate(ParameterManagerClient parameterManagerClient, ParameterManagerClientFactory clientFactory, GcpProjectIdProvider projectIdProvider) {
        this.parameterManagerClient = parameterManagerClient;
        this.clientFactory = clientFactory;
        this.projectIdProvider = projectIdProvider;
        this.allowDefaultParameterValue = false;
    }

    private ParameterManagerClient getClient(@Nullable String locationId) {
        return this.clientFactory == null ? this.parameterManagerClient : this.clientFactory.getClient(locationId);
    }

    public ParameterManagerTemplate setAllowDefaultParameterValue(boolean allowDefaultParameterValue) {
        this.allowDefaultParameterValue = allowDefaultParameterValue;
        return this;
    }

    public String getProjectId() {
        return this.projectIdProvider.getProjectId();
    }

    @Override
    public void createParameter(String locationId, String parameterId, String versionId, String payload) {
        this.createNewParameterVersion(this.projectIdProvider.getProjectId(), locationId, parameterId, versionId, ByteString.copyFromUtf8((String)payload), ParameterFormat.UNFORMATTED);
    }

    @Override
    public void createParameter(String projectId, String locationId, String parameterId, String versionId, String payload) {
        this.createNewParameterVersion(projectId, locationId, parameterId, versionId, ByteString.copyFromUtf8((String)payload), ParameterFormat.UNFORMATTED);
    }

    @Override
    public void createParameter(String locationId, String parameterId, String versionId, String payload, ParameterFormat format) {
        this.createNewParameterVersion(this.projectIdProvider.getProjectId(), locationId, parameterId, versionId, ByteString.copyFromUtf8((String)payload), format);
    }

    @Override
    public void createParameter(String projectId, String locationId, String parameterId, String versionId, String payload, ParameterFormat format) {
        this.createNewParameterVersion(projectId, locationId, parameterId, versionId, ByteString.copyFromUtf8((String)payload), format);
    }

    @Override
    public void createParameter(String locationId, String parameterId, String versionId, byte[] payload) {
        this.createNewParameterVersion(this.projectIdProvider.getProjectId(), locationId, parameterId, versionId, ByteString.copyFrom((byte[])payload), ParameterFormat.UNFORMATTED);
    }

    @Override
    public void createParameter(String locationId, String parameterId, String versionId, byte[] payload, ParameterFormat format) {
        this.createNewParameterVersion(this.projectIdProvider.getProjectId(), locationId, parameterId, versionId, ByteString.copyFrom((byte[])payload), format);
    }

    @Override
    public void createParameter(String projectId, String locationId, String parameterId, String versionId, byte[] payload, ParameterFormat format) {
        this.createNewParameterVersion(projectId, locationId, parameterId, versionId, ByteString.copyFrom((byte[])payload), format);
    }

    @Override
    public void enableParameterVersion(String locationId, String parameterId, String versionId) {
        this.enableParameterVersion(this.projectIdProvider.getProjectId(), locationId, parameterId, versionId);
    }

    @Override
    public void enableParameterVersion(String projectId, String locationId, String parameterId, String versionId) {
        ParameterVersionName parameterVersionName = ParameterVersionName.of((String)projectId, (String)locationId, (String)parameterId, (String)versionId);
        ParameterVersion parameterVersion = ParameterVersion.newBuilder().setName(parameterVersionName.toString()).setDisabled(false).build();
        UpdateParameterVersionRequest request = UpdateParameterVersionRequest.newBuilder().setParameterVersion(parameterVersion).setUpdateMask(FieldMaskUtil.fromString((String)"disabled")).build();
        this.getClient(locationId).updateParameterVersion(request);
    }

    @Override
    public void disableParameterVersion(String locationId, String parameterId, String versionId) {
        this.disableParameterVersion(this.projectIdProvider.getProjectId(), locationId, parameterId, versionId);
    }

    @Override
    public void disableParameterVersion(String projectId, String locationId, String parameterId, String versionId) {
        ParameterVersionName parameterVersionName = ParameterVersionName.of((String)projectId, (String)locationId, (String)parameterId, (String)versionId);
        ParameterVersion parameterVersion = ParameterVersion.newBuilder().setName(parameterVersionName.toString()).setDisabled(true).build();
        UpdateParameterVersionRequest request = UpdateParameterVersionRequest.newBuilder().setParameterVersion(parameterVersion).setUpdateMask(FieldMaskUtil.fromString((String)"disabled")).build();
        this.getClient(locationId).updateParameterVersion(request);
    }

    @Override
    public void deleteParameter(String locationId, String parameterId) {
        this.deleteParameter(this.projectIdProvider.getProjectId(), locationId, parameterId);
    }

    @Override
    public void deleteParameter(String projectId, String locationId, String parameterId) {
        ParameterName parameterName = ParameterName.of((String)projectId, (String)locationId, (String)parameterId);
        DeleteParameterRequest request = DeleteParameterRequest.newBuilder().setName(parameterName.toString()).build();
        this.getClient(locationId).deleteParameter(request);
    }

    @Override
    public void deleteParameterVersion(String locationId, String parameterId, String versionId) {
        this.deleteParameterVersion(this.projectIdProvider.getProjectId(), locationId, parameterId, versionId);
    }

    @Override
    public void deleteParameterVersion(String projectId, String locationId, String parameterId, String versionId) {
        ParameterVersionName parameterVersionName = ParameterVersionName.of((String)projectId, (String)locationId, (String)parameterId, (String)versionId);
        DeleteParameterVersionRequest request = DeleteParameterVersionRequest.newBuilder().setName(parameterVersionName.toString()).build();
        this.getClient(locationId).deleteParameterVersion(request);
    }

    @Override
    public boolean parameterExists(String locationId, String parameterId) {
        return this.parameterExists(this.projectIdProvider.getProjectId(), locationId, parameterId);
    }

    @Override
    public boolean parameterExists(String projectId, String locationId, String parameterId) {
        ParameterName parameterName = ParameterName.of((String)projectId, (String)locationId, (String)parameterId);
        try {
            this.getClient(locationId).getParameter(parameterName);
        }
        catch (NotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    public boolean parameterVersionExists(String locationId, String parameterId, String versionId) {
        return this.parameterVersionExists(this.projectIdProvider.getProjectId(), locationId, parameterId, versionId);
    }

    @Override
    public boolean parameterVersionExists(String projectId, String locationId, String parameterId, String versionId) {
        ParameterVersionName parameterVersionName = ParameterVersionName.of((String)projectId, (String)locationId, (String)parameterId, (String)versionId);
        GetParameterVersionRequest request = GetParameterVersionRequest.newBuilder().setName(parameterVersionName.toString()).build();
        try {
            this.getClient(locationId).getParameterVersion(request);
        }
        catch (NotFoundException e) {
            return false;
        }
        return true;
    }

    @Override
    @Nullable
    public String getParameterString(String parameterIdentifier) {
        ByteString parameterByteString = this.getParameterByteString(parameterIdentifier);
        return parameterByteString == null ? null : parameterByteString.toStringUtf8();
    }

    @Override
    @Nullable
    public byte[] getParameterBytes(String parameterIdentifier) {
        ByteString parameterByteString = this.getParameterByteString(parameterIdentifier);
        return parameterByteString == null ? null : parameterByteString.toByteArray();
    }

    @Override
    @Nullable
    public String renderedParameterVersionString(String parameterIdentifier) {
        ByteString renderedParameterByteString = this.getRenderedParameterByteString(parameterIdentifier);
        return renderedParameterByteString == null ? null : renderedParameterByteString.toStringUtf8();
    }

    @Override
    @Nullable
    public byte[] renderedParameterVersionBytes(String parameterIdentifier) {
        ByteString renderedParameterByteString = this.getRenderedParameterByteString(parameterIdentifier);
        return renderedParameterByteString == null ? null : renderedParameterByteString.toByteArray();
    }

    ByteString getParameterByteString(String parameterIdentifier) {
        ParameterVersionName parameterVersionName = ParameterManagerPropertyUtils.getParameterVersionName(parameterIdentifier, this.projectIdProvider);
        return this.getParameterByteString(parameterVersionName);
    }

    ByteString getParameterByteString(ParameterVersionName parameterVersionName) {
        ByteString parameterData;
        try {
            parameterData = this.getClient(parameterVersionName.getLocation()).getParameterVersion(parameterVersionName).getPayload().getData();
        }
        catch (NotFoundException ex) {
            LOGGER.warn((Object)(parameterVersionName.toString() + " doesn't exist in Parameter Manager."));
            if (!this.allowDefaultParameterValue) {
                throw ex;
            }
            return null;
        }
        return parameterData;
    }

    ByteString getRenderedParameterByteString(String parameterIdentifier) {
        ParameterVersionName parameterVersionName = ParameterManagerPropertyUtils.getParameterVersionName(parameterIdentifier, this.projectIdProvider);
        return this.getRenderedParameterByteString(parameterVersionName);
    }

    ByteString getRenderedParameterByteString(ParameterVersionName parameterVersionName) {
        ByteString parameterData;
        try {
            parameterData = this.getClient(parameterVersionName.getLocation()).renderParameterVersion(parameterVersionName).getRenderedPayload();
        }
        catch (NotFoundException ex) {
            LOGGER.warn((Object)(parameterVersionName.toString() + " doesn't exist in Parameter Manager."));
            if (!this.allowDefaultParameterValue) {
                throw ex;
            }
            return null;
        }
        return parameterData;
    }

    private void createNewParameterVersion(String projectId, String locationId, String parameterId, String versionId, ByteString payload, ParameterFormat format) {
        if (!this.parameterExists(projectId, locationId, parameterId)) {
            this.createParameterInternal(projectId, locationId, parameterId, format);
        }
        ParameterName parameterName = ParameterName.of((String)projectId, (String)locationId, (String)parameterId);
        ParameterVersionPayload parameterVersionPayload = ParameterVersionPayload.newBuilder().setData(payload).build();
        CreateParameterVersionRequest payloadRequest = CreateParameterVersionRequest.newBuilder().setParent(parameterName.toString()).setParameterVersionId(versionId).setParameterVersion(ParameterVersion.newBuilder().setPayload(parameterVersionPayload).build()).build();
        this.getClient(locationId).createParameterVersion(payloadRequest);
    }

    private void createParameterInternal(String projectId, String locationId, String parameterId, ParameterFormat format) {
        LocationName locationName = LocationName.of((String)projectId, (String)locationId);
        Parameter parameter = Parameter.newBuilder().setFormat(format).build();
        CreateParameterRequest request = CreateParameterRequest.newBuilder().setParent(locationName.toString()).setParameterId(parameterId).setParameter(parameter).build();
        this.getClient(locationId).createParameter(request);
    }
}

