/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.stream.binder.pubsub.provisioning;

import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.cloud.spring.pubsub.PubSubAdmin;
import com.google.cloud.spring.stream.binder.pubsub.properties.PubSubConsumerProperties;
import com.google.cloud.spring.stream.binder.pubsub.properties.PubSubProducerProperties;
import com.google.cloud.spring.stream.binder.pubsub.provisioning.PubSubConsumerDestination;
import com.google.cloud.spring.stream.binder.pubsub.provisioning.PubSubProducerDestination;
import com.google.protobuf.Duration;
import com.google.pubsub.v1.DeadLetterPolicy;
import com.google.pubsub.v1.ExpirationPolicy;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PubSubChannelProvisioner
implements ProvisioningProvider<ExtendedConsumerProperties<PubSubConsumerProperties>, ExtendedProducerProperties<PubSubProducerProperties>> {
    private static final Log LOGGER = LogFactory.getLog(PubSubChannelProvisioner.class);
    private final PubSubAdmin pubSubAdmin;
    private final Set<String> anonymousGroupSubscriptionNames = new HashSet<String>();

    public PubSubChannelProvisioner(PubSubAdmin pubSubAdmin) {
        this.pubSubAdmin = pubSubAdmin;
    }

    public ProducerDestination provisionProducerDestination(String topic, ExtendedProducerProperties<PubSubProducerProperties> properties) {
        this.ensureTopicExists(topic, ((PubSubProducerProperties)properties.getExtension()).isAutoCreateResources());
        return new PubSubProducerDestination(topic);
    }

    public ConsumerDestination provisionConsumerDestination(String topicName, String group, ExtendedConsumerProperties<PubSubConsumerProperties> properties) {
        String topicShortName;
        String customName = ((PubSubConsumerProperties)properties.getExtension()).getSubscriptionName();
        boolean autoCreate = ((PubSubConsumerProperties)properties.getExtension()).isAutoCreateResources();
        String string = topicShortName = TopicName.isParsableFrom((String)topicName) ? TopicName.parse((String)topicName).getTopic() : topicName;
        if (autoCreate) {
            this.ensureTopicExists(topicShortName, autoCreate);
        }
        Object subscriptionName = null;
        if (StringUtils.hasText((String)customName)) {
            if (StringUtils.hasText((String)group)) {
                LOGGER.warn((Object)("Either subscriptionName or group can be specified, but not both. Using subscriptionName '" + customName + "'."));
            }
            subscriptionName = customName;
        } else if (StringUtils.hasText((String)group)) {
            subscriptionName = topicShortName + "." + group;
        }
        if (autoCreate) {
            if (!StringUtils.hasText((String)subscriptionName)) {
                subscriptionName = "anonymous." + topicShortName + "." + UUID.randomUUID();
                this.anonymousGroupSubscriptionNames.add((String)subscriptionName);
            }
            this.ensureSubscriptionExists((String)subscriptionName, topicName, (PubSubConsumerProperties)properties.getExtension());
        }
        Assert.hasText((String)subscriptionName, (String)"Subscription Name cannot be null or empty");
        return new PubSubConsumerDestination((String)subscriptionName);
    }

    public void afterUnbindConsumer(ConsumerDestination destination) {
        if (this.anonymousGroupSubscriptionNames.remove(destination.getName())) {
            try {
                this.pubSubAdmin.deleteSubscription(destination.getName());
            }
            catch (Exception ex) {
                LOGGER.warn((Object)("Failed to delete auto-created anonymous subscription '" + destination.getName() + "'."));
            }
        }
    }

    Topic ensureTopicExists(String topicName, boolean autoCreate) {
        Topic topic = this.pubSubAdmin.getTopic(topicName);
        if (topic != null) {
            return topic;
        }
        if (autoCreate) {
            try {
                return this.pubSubAdmin.createTopic(topicName);
            }
            catch (AlreadyExistsException alreadyExistsException) {
                return this.ensureTopicExists(topicName, false);
            }
        }
        throw new ProvisioningException("Non-existing '" + topicName + "' topic.");
    }

    Subscription ensureSubscriptionExists(String subscriptionName, String topicName, PubSubConsumerProperties properties) {
        Subscription subscription = this.pubSubAdmin.getSubscription(subscriptionName);
        if (subscription == null) {
            return this.createSubscription(subscriptionName, topicName, properties);
        }
        return subscription;
    }

    private Subscription createSubscription(String subscriptionName, String topicName, PubSubConsumerProperties properties) {
        PubSubConsumerProperties.ExpirationPolicy expirationPolicy;
        Subscription.Builder builder = Subscription.newBuilder().setName(subscriptionName).setTopic(topicName);
        PubSubConsumerProperties.DeadLetterPolicy deadLetterPolicy = properties.getDeadLetterPolicy();
        if (deadLetterPolicy != null) {
            String dlTopicName = deadLetterPolicy.getDeadLetterTopic();
            Assert.hasText((String)dlTopicName, (String)"Dead letter policy cannot have null or empty topic");
            Topic dlTopic = this.ensureTopicExists(dlTopicName, properties.isAutoCreateResources());
            DeadLetterPolicy.Builder dlpBuilder = DeadLetterPolicy.newBuilder().setDeadLetterTopic(dlTopic.getName());
            Integer maxAttempts = deadLetterPolicy.getMaxDeliveryAttempts();
            if (maxAttempts != null) {
                dlpBuilder.setMaxDeliveryAttempts(maxAttempts.intValue());
            }
            builder.setDeadLetterPolicy(dlpBuilder);
        }
        if ((expirationPolicy = properties.getExpirationPolicy()) != null) {
            ExpirationPolicy.Builder epBuilder = ExpirationPolicy.newBuilder();
            if (expirationPolicy.getTtl() != null) {
                long desiredSeconds = expirationPolicy.getTtl().getSeconds();
                epBuilder.setTtl(Duration.newBuilder().setSeconds(desiredSeconds).build());
            }
            builder.setExpirationPolicy(epBuilder);
        }
        return this.pubSubAdmin.createSubscription(builder);
    }
}

