/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.pubsub.support.PubSubSubscriptionUtils;
import com.google.cloud.spring.pubsub.support.PubSubTopicUtils;
import com.google.pubsub.v1.ProjectName;
import com.google.pubsub.v1.PushConfig;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.util.Assert;

public class PubSubAdmin
implements AutoCloseable {
    protected static final int MIN_ACK_DEADLINE_SECONDS = 10;
    protected static final int MAX_ACK_DEADLINE_SECONDS = 600;
    private static final String NO_TOPIC_SPECIFIED = "No topic name was specified.";
    private final String projectId;
    private final TopicAdminClient topicAdminClient;
    private final SubscriptionAdminClient subscriptionAdminClient;
    private int defaultAckDeadline = 10;

    public PubSubAdmin(GcpProjectIdProvider projectIdProvider, CredentialsProvider credentialsProvider) throws IOException {
        this(projectIdProvider, TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setCredentialsProvider(credentialsProvider)).build()), SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setCredentialsProvider(credentialsProvider)).build()));
    }

    public PubSubAdmin(GcpProjectIdProvider projectIdProvider, TopicAdminClient topicAdminClient, SubscriptionAdminClient subscriptionAdminClient) {
        Assert.notNull((Object)projectIdProvider, (String)"The project ID provider can't be null.");
        Assert.notNull((Object)topicAdminClient, (String)"The topic administration client can't be null");
        Assert.notNull((Object)subscriptionAdminClient, (String)"The subscription administration client can't be null");
        this.projectId = projectIdProvider.getProjectId();
        Assert.hasText((String)this.projectId, (String)"The project ID can't be null or empty.");
        this.topicAdminClient = topicAdminClient;
        this.subscriptionAdminClient = subscriptionAdminClient;
    }

    public Topic createTopic(String topicName) {
        Assert.hasText((String)topicName, (String)NO_TOPIC_SPECIFIED);
        return this.topicAdminClient.createTopic(PubSubTopicUtils.toTopicName(topicName, this.projectId));
    }

    public Topic getTopic(String topicName) {
        Assert.hasText((String)topicName, (String)NO_TOPIC_SPECIFIED);
        try {
            return this.topicAdminClient.getTopic(PubSubTopicUtils.toTopicName(topicName, this.projectId));
        }
        catch (ApiException aex) {
            if (aex.getStatusCode().getCode() == StatusCode.Code.NOT_FOUND) {
                return null;
            }
            throw aex;
        }
    }

    public void deleteTopic(String topicName) {
        Assert.hasText((String)topicName, (String)NO_TOPIC_SPECIFIED);
        this.topicAdminClient.deleteTopic(PubSubTopicUtils.toTopicName(topicName, this.projectId));
    }

    public List<Topic> listTopics() {
        TopicAdminClient.ListTopicsPagedResponse topicListPage = this.topicAdminClient.listTopics(ProjectName.of((String)this.projectId));
        ArrayList topics = new ArrayList();
        topicListPage.iterateAll().forEach(topics::add);
        return Collections.unmodifiableList(topics);
    }

    public Subscription createSubscription(String subscriptionName, String topicName) {
        return this.createSubscription(subscriptionName, topicName, null, null);
    }

    public Subscription createSubscription(String subscriptionName, String topicName, Integer ackDeadline) {
        return this.createSubscription(subscriptionName, topicName, ackDeadline, null);
    }

    public Subscription createSubscription(String subscriptionName, String topicName, String pushEndpoint) {
        return this.createSubscription(subscriptionName, topicName, null, pushEndpoint);
    }

    public Subscription createSubscription(String subscriptionName, String topicName, Integer ackDeadline, String pushEndpoint) {
        Assert.hasText((String)subscriptionName, (String)"No subscription name was specified.");
        Assert.hasText((String)topicName, (String)NO_TOPIC_SPECIFIED);
        int finalAckDeadline = this.defaultAckDeadline;
        if (ackDeadline != null) {
            this.validateAckDeadline(ackDeadline);
            finalAckDeadline = ackDeadline;
        }
        PushConfig.Builder pushConfigBuilder = PushConfig.newBuilder();
        if (pushEndpoint != null) {
            pushConfigBuilder.setPushEndpoint(pushEndpoint);
        }
        return this.subscriptionAdminClient.createSubscription(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId), PubSubTopicUtils.toTopicName(topicName, this.projectId), pushConfigBuilder.build(), finalAckDeadline);
    }

    public Subscription getSubscription(String subscriptionName) {
        Assert.hasText((String)subscriptionName, (String)"No subscription name was specified");
        try {
            return this.subscriptionAdminClient.getSubscription(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId));
        }
        catch (ApiException aex) {
            if (aex.getStatusCode().getCode() == StatusCode.Code.NOT_FOUND) {
                return null;
            }
            throw aex;
        }
    }

    public void deleteSubscription(String subscriptionName) {
        Assert.hasText((String)subscriptionName, (String)"No subscription name was specified");
        this.subscriptionAdminClient.deleteSubscription(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId));
    }

    public List<Subscription> listSubscriptions() {
        SubscriptionAdminClient.ListSubscriptionsPagedResponse subscriptionsPage = this.subscriptionAdminClient.listSubscriptions(ProjectName.of((String)this.projectId));
        ArrayList subscriptions = new ArrayList();
        subscriptionsPage.iterateAll().forEach(subscriptions::add);
        return Collections.unmodifiableList(subscriptions);
    }

    public int getDefaultAckDeadline() {
        return this.defaultAckDeadline;
    }

    public void setDefaultAckDeadline(int defaultAckDeadline) {
        this.validateAckDeadline(defaultAckDeadline);
        this.defaultAckDeadline = defaultAckDeadline;
    }

    private void validateAckDeadline(int ackDeadline) {
        Assert.isTrue((ackDeadline >= 10 && ackDeadline <= 600 ? 1 : 0) != 0, (String)"The acknowledgement deadline must be between 10 and 600 seconds.");
    }

    @Override
    public void close() throws Exception {
        this.topicAdminClient.close();
        this.subscriptionAdminClient.close();
    }
}

