/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.core.subscriber;

import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutureCallback;
import com.google.api.core.ApiFutures;
import com.google.cloud.pubsub.v1.AckReplyConsumer;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberOperations;
import com.google.cloud.spring.pubsub.support.AcknowledgeablePubsubMessage;
import com.google.cloud.spring.pubsub.support.BasicAcknowledgeablePubsubMessage;
import com.google.cloud.spring.pubsub.support.PubSubSubscriptionUtils;
import com.google.cloud.spring.pubsub.support.SubscriberFactory;
import com.google.cloud.spring.pubsub.support.converter.ConvertedAcknowledgeablePubsubMessage;
import com.google.cloud.spring.pubsub.support.converter.ConvertedBasicAcknowledgeablePubsubMessage;
import com.google.cloud.spring.pubsub.support.converter.PubSubMessageConverter;
import com.google.cloud.spring.pubsub.support.converter.SimplePubSubMessageConverter;
import com.google.protobuf.Empty;
import com.google.pubsub.v1.AcknowledgeRequest;
import com.google.pubsub.v1.ModifyAckDeadlineRequest;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PubsubMessage;
import com.google.pubsub.v1.PullRequest;
import com.google.pubsub.v1.PullResponse;
import com.google.pubsub.v1.ReceivedMessage;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.ListenableFuture;
import org.springframework.util.concurrent.SettableListenableFuture;

public class PubSubSubscriberTemplate
implements PubSubSubscriberOperations,
DisposableBean {
    private final SubscriberFactory subscriberFactory;
    private final SubscriberStub subscriberStub;
    private PubSubMessageConverter pubSubMessageConverter = new SimplePubSubMessageConverter();
    private final ExecutorService defaultAckExecutor = Executors.newSingleThreadExecutor();
    private Executor ackExecutor = this.defaultAckExecutor;
    private Executor asyncPullExecutor = Runnable::run;

    public PubSubSubscriberTemplate(SubscriberFactory subscriberFactory) {
        Assert.notNull((Object)subscriberFactory, (String)"The subscriberFactory can't be null.");
        this.subscriberFactory = subscriberFactory;
        this.subscriberStub = this.subscriberFactory.createSubscriberStub();
    }

    public PubSubMessageConverter getMessageConverter() {
        return this.pubSubMessageConverter;
    }

    public void setMessageConverter(PubSubMessageConverter pubSubMessageConverter) {
        Assert.notNull((Object)pubSubMessageConverter, (String)"The pubSubMessageConverter can't be null.");
        this.pubSubMessageConverter = pubSubMessageConverter;
    }

    public void setAckExecutor(Executor ackExecutor) {
        Assert.notNull((Object)ackExecutor, (String)"ackExecutor can't be null.");
        this.ackExecutor = ackExecutor;
    }

    public void setAsyncPullExecutor(Executor asyncPullExecutor) {
        Assert.notNull((Object)asyncPullExecutor, (String)"asyncPullExecutor can't be null.");
        this.asyncPullExecutor = asyncPullExecutor;
    }

    @Override
    public Subscriber subscribe(String subscription, Consumer<BasicAcknowledgeablePubsubMessage> messageConsumer) {
        Assert.notNull(messageConsumer, (String)"The messageConsumer can't be null.");
        Subscriber subscriber = this.subscriberFactory.createSubscriber(subscription, (message, ackReplyConsumer) -> messageConsumer.accept(new PushedAcknowledgeablePubsubMessage(PubSubSubscriptionUtils.toProjectSubscriptionName(subscription, this.subscriberFactory.getProjectId()), message, ackReplyConsumer)));
        subscriber.startAsync();
        return subscriber;
    }

    @Override
    public <T> Subscriber subscribeAndConvert(String subscription, Consumer<ConvertedBasicAcknowledgeablePubsubMessage<T>> messageConsumer, Class<T> payloadType) {
        Assert.notNull(messageConsumer, (String)"The messageConsumer can't be null.");
        Subscriber subscriber = this.subscriberFactory.createSubscriber(subscription, (message, ackReplyConsumer) -> messageConsumer.accept(new ConvertedPushedAcknowledgeablePubsubMessage(PubSubSubscriptionUtils.toProjectSubscriptionName(subscription, this.subscriberFactory.getProjectId()), message, this.getMessageConverter().fromPubSubMessage(message, payloadType), ackReplyConsumer)));
        subscriber.startAsync();
        return subscriber;
    }

    private List<AcknowledgeablePubsubMessage> pull(PullRequest pullRequest) {
        Assert.notNull((Object)pullRequest, (String)"The pull request can't be null.");
        PullResponse pullResponse = (PullResponse)this.subscriberStub.pullCallable().call((Object)pullRequest);
        return this.toAcknowledgeablePubsubMessageList(pullResponse.getReceivedMessagesList(), pullRequest.getSubscription());
    }

    private ListenableFuture<List<AcknowledgeablePubsubMessage>> pullAsync(final PullRequest pullRequest) {
        Assert.notNull((Object)pullRequest, (String)"The pull request can't be null.");
        ApiFuture pullFuture = this.subscriberStub.pullCallable().futureCall((Object)pullRequest);
        final SettableListenableFuture settableFuture = new SettableListenableFuture();
        ApiFutures.addCallback((ApiFuture)pullFuture, (ApiFutureCallback)new ApiFutureCallback<PullResponse>(){

            public void onFailure(Throwable throwable) {
                settableFuture.setException(throwable);
            }

            public void onSuccess(PullResponse pullResponse) {
                List result = PubSubSubscriberTemplate.this.toAcknowledgeablePubsubMessageList(pullResponse.getReceivedMessagesList(), pullRequest.getSubscription());
                settableFuture.set((Object)result);
            }
        }, (Executor)this.asyncPullExecutor);
        return settableFuture;
    }

    private List<AcknowledgeablePubsubMessage> toAcknowledgeablePubsubMessageList(List<ReceivedMessage> messages, String subscriptionId) {
        return messages.stream().map(message -> new PulledAcknowledgeablePubsubMessage(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionId, this.subscriberFactory.getProjectId()), message.getMessage(), message.getAckId())).collect(Collectors.toList());
    }

    @Override
    public List<AcknowledgeablePubsubMessage> pull(String subscription, Integer maxMessages, Boolean returnImmediately) {
        return this.pull(this.subscriberFactory.createPullRequest(subscription, maxMessages, returnImmediately));
    }

    @Override
    public ListenableFuture<List<AcknowledgeablePubsubMessage>> pullAsync(String subscription, Integer maxMessages, Boolean returnImmediately) {
        return this.pullAsync(this.subscriberFactory.createPullRequest(subscription, maxMessages, returnImmediately));
    }

    @Override
    public <T> List<ConvertedAcknowledgeablePubsubMessage<T>> pullAndConvert(String subscription, Integer maxMessages, Boolean returnImmediately, Class<T> payloadType) {
        List<AcknowledgeablePubsubMessage> ackableMessages = this.pull(subscription, maxMessages, returnImmediately);
        return this.toConvertedAcknowledgeablePubsubMessages(payloadType, ackableMessages);
    }

    @Override
    public <T> ListenableFuture<List<ConvertedAcknowledgeablePubsubMessage<T>>> pullAndConvertAsync(String subscription, Integer maxMessages, Boolean returnImmediately, Class<T> payloadType) {
        SettableListenableFuture settableFuture = new SettableListenableFuture();
        this.pullAsync(subscription, maxMessages, returnImmediately).addCallback(ackableMessages -> settableFuture.set(this.toConvertedAcknowledgeablePubsubMessages(payloadType, (List<AcknowledgeablePubsubMessage>)ackableMessages)), arg_0 -> ((SettableListenableFuture)settableFuture).setException(arg_0));
        return settableFuture;
    }

    private <T> List<ConvertedAcknowledgeablePubsubMessage<T>> toConvertedAcknowledgeablePubsubMessages(Class<T> payloadType, List<AcknowledgeablePubsubMessage> ackableMessages) {
        return ackableMessages.stream().map(m -> new ConvertedPulledAcknowledgeablePubsubMessage((AcknowledgeablePubsubMessage)m, this.pubSubMessageConverter.fromPubSubMessage(m.getPubsubMessage(), payloadType))).collect(Collectors.toList());
    }

    @Override
    public List<PubsubMessage> pullAndAck(String subscription, Integer maxMessages, Boolean returnImmediately) {
        PullRequest pullRequest = this.subscriberFactory.createPullRequest(subscription, maxMessages, returnImmediately);
        List<AcknowledgeablePubsubMessage> ackableMessages = this.pull(pullRequest);
        if (!ackableMessages.isEmpty()) {
            this.ack(ackableMessages);
        }
        return ackableMessages.stream().map(BasicAcknowledgeablePubsubMessage::getPubsubMessage).collect(Collectors.toList());
    }

    @Override
    public ListenableFuture<List<PubsubMessage>> pullAndAckAsync(String subscription, Integer maxMessages, Boolean returnImmediately) {
        PullRequest pullRequest = this.subscriberFactory.createPullRequest(subscription, maxMessages, returnImmediately);
        SettableListenableFuture settableFuture = new SettableListenableFuture();
        this.pullAsync(pullRequest).addCallback(ackableMessages -> {
            if (!ackableMessages.isEmpty()) {
                this.ack((Collection<? extends AcknowledgeablePubsubMessage>)ackableMessages);
            }
            List messages = ackableMessages.stream().map(BasicAcknowledgeablePubsubMessage::getPubsubMessage).collect(Collectors.toList());
            settableFuture.set(messages);
        }, arg_0 -> ((SettableListenableFuture)settableFuture).setException(arg_0));
        return settableFuture;
    }

    @Override
    public PubsubMessage pullNext(String subscription) {
        List<PubsubMessage> receivedMessageList = this.pullAndAck(subscription, 1, true);
        return receivedMessageList.isEmpty() ? null : receivedMessageList.get(0);
    }

    @Override
    public ListenableFuture<PubsubMessage> pullNextAsync(String subscription) {
        SettableListenableFuture settableFuture = new SettableListenableFuture();
        this.pullAndAckAsync(subscription, 1, true).addCallback(messages -> {
            PubsubMessage message = messages.isEmpty() ? null : (PubsubMessage)messages.get(0);
            settableFuture.set((Object)message);
        }, arg_0 -> ((SettableListenableFuture)settableFuture).setException(arg_0));
        return settableFuture;
    }

    public SubscriberFactory getSubscriberFactory() {
        return this.subscriberFactory;
    }

    @Override
    public ListenableFuture<Void> ack(Collection<? extends AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages) {
        Assert.notEmpty(acknowledgeablePubsubMessages, (String)"The acknowledgeablePubsubMessages can't be empty.");
        return this.doBatchedAsyncOperation(acknowledgeablePubsubMessages, this::ack);
    }

    @Override
    public ListenableFuture<Void> nack(Collection<? extends AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages) {
        return this.modifyAckDeadline(acknowledgeablePubsubMessages, 0);
    }

    @Override
    public ListenableFuture<Void> modifyAckDeadline(Collection<? extends AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages, int ackDeadlineSeconds) {
        Assert.notEmpty(acknowledgeablePubsubMessages, (String)"The acknowledgeablePubsubMessages can't be empty.");
        Assert.isTrue((ackDeadlineSeconds >= 0 ? 1 : 0) != 0, (String)"The ackDeadlineSeconds must not be negative.");
        return this.doBatchedAsyncOperation(acknowledgeablePubsubMessages, (subscriptionName, ackIds) -> this.modifyAckDeadline((String)subscriptionName, (Collection<String>)ackIds, ackDeadlineSeconds));
    }

    public void destroy() {
        this.defaultAckExecutor.shutdown();
        this.subscriberStub.close();
    }

    private ApiFuture<Empty> ack(String subscriptionName, Collection<String> ackIds) {
        AcknowledgeRequest acknowledgeRequest = AcknowledgeRequest.newBuilder().addAllAckIds(ackIds).setSubscription(subscriptionName).build();
        return this.subscriberStub.acknowledgeCallable().futureCall((Object)acknowledgeRequest);
    }

    private ApiFuture<Empty> modifyAckDeadline(String subscriptionName, Collection<String> ackIds, int ackDeadlineSeconds) {
        ModifyAckDeadlineRequest modifyAckDeadlineRequest = ModifyAckDeadlineRequest.newBuilder().setAckDeadlineSeconds(ackDeadlineSeconds).addAllAckIds(ackIds).setSubscription(subscriptionName).build();
        return this.subscriberStub.modifyAckDeadlineCallable().futureCall((Object)modifyAckDeadlineRequest);
    }

    private ListenableFuture<Void> doBatchedAsyncOperation(Collection<? extends AcknowledgeablePubsubMessage> acknowledgeablePubsubMessages, BiFunction<String, List<String>, ApiFuture<Empty>> asyncOperation) {
        Map groupedMessages = acknowledgeablePubsubMessages.stream().collect(Collectors.groupingBy(BasicAcknowledgeablePubsubMessage::getProjectSubscriptionName, Collectors.mapping(AcknowledgeablePubsubMessage::getAckId, Collectors.toList())));
        Assert.state((groupedMessages.keySet().stream().map(ProjectSubscriptionName::getProject).distinct().count() == 1L ? 1 : 0) != 0, (String)"The project id of all messages must match.");
        final SettableListenableFuture settableListenableFuture = new SettableListenableFuture();
        final int numExpectedFutures = groupedMessages.size();
        final AtomicInteger numCompletedFutures = new AtomicInteger();
        groupedMessages.forEach((psName, ackIds) -> {
            ApiFuture ackApiFuture = (ApiFuture)asyncOperation.apply(psName.toString(), (List<String>)ackIds);
            ApiFutures.addCallback((ApiFuture)ackApiFuture, (ApiFutureCallback)new ApiFutureCallback<Empty>(){

                public void onFailure(Throwable throwable) {
                    this.processResult(throwable);
                }

                public void onSuccess(Empty empty) {
                    this.processResult(null);
                }

                private void processResult(Throwable throwable) {
                    if (throwable != null) {
                        settableListenableFuture.setException(throwable);
                    } else if (numCompletedFutures.incrementAndGet() == numExpectedFutures) {
                        settableListenableFuture.set(null);
                    }
                }
            }, (Executor)this.ackExecutor);
        });
        return settableListenableFuture;
    }

    private static class ConvertedPushedAcknowledgeablePubsubMessage<T>
    extends PushedAcknowledgeablePubsubMessage
    implements ConvertedBasicAcknowledgeablePubsubMessage<T> {
        private final T payload;

        ConvertedPushedAcknowledgeablePubsubMessage(ProjectSubscriptionName projectSubscriptionName, PubsubMessage message, T payload, AckReplyConsumer ackReplyConsumer) {
            super(projectSubscriptionName, message, ackReplyConsumer);
            this.payload = payload;
        }

        @Override
        public T getPayload() {
            return this.payload;
        }
    }

    private class ConvertedPulledAcknowledgeablePubsubMessage<T>
    extends PulledAcknowledgeablePubsubMessage
    implements ConvertedAcknowledgeablePubsubMessage<T> {
        private final T payload;

        ConvertedPulledAcknowledgeablePubsubMessage(AcknowledgeablePubsubMessage message, T payload) {
            super(message.getProjectSubscriptionName(), message.getPubsubMessage(), message.getAckId());
            this.payload = payload;
        }

        @Override
        public T getPayload() {
            return this.payload;
        }
    }

    private static class PushedAcknowledgeablePubsubMessage
    extends AbstractBasicAcknowledgeablePubsubMessage {
        private final AckReplyConsumer ackReplyConsumer;

        PushedAcknowledgeablePubsubMessage(ProjectSubscriptionName projectSubscriptionName, PubsubMessage message, AckReplyConsumer ackReplyConsumer) {
            super(projectSubscriptionName, message);
            this.ackReplyConsumer = ackReplyConsumer;
        }

        @Override
        public ListenableFuture<Void> ack() {
            SettableListenableFuture settableListenableFuture = new SettableListenableFuture();
            try {
                this.ackReplyConsumer.ack();
                settableListenableFuture.set(null);
            }
            catch (Throwable throwable) {
                settableListenableFuture.setException(throwable);
            }
            return settableListenableFuture;
        }

        @Override
        public ListenableFuture<Void> nack() {
            SettableListenableFuture settableListenableFuture = new SettableListenableFuture();
            try {
                this.ackReplyConsumer.nack();
                settableListenableFuture.set(null);
            }
            catch (Throwable throwable) {
                settableListenableFuture.setException(throwable);
            }
            return settableListenableFuture;
        }

        public String toString() {
            return "PushedAcknowledgeablePubsubMessage{projectId='" + this.getProjectSubscriptionName().getProject() + '\'' + ", subscriptionName='" + this.getProjectSubscriptionName().getSubscription() + '\'' + ", message=" + this.getPubsubMessage() + '}';
        }
    }

    private class PulledAcknowledgeablePubsubMessage
    extends AbstractBasicAcknowledgeablePubsubMessage
    implements AcknowledgeablePubsubMessage {
        private final String ackId;

        PulledAcknowledgeablePubsubMessage(ProjectSubscriptionName projectSubscriptionName, PubsubMessage message, String ackId) {
            super(projectSubscriptionName, message);
            this.ackId = ackId;
        }

        @Override
        public String getAckId() {
            return this.ackId;
        }

        @Override
        public ListenableFuture<Void> ack() {
            return PubSubSubscriberTemplate.this.ack(Collections.singleton(this));
        }

        @Override
        public ListenableFuture<Void> nack() {
            return this.modifyAckDeadline(0);
        }

        @Override
        public ListenableFuture<Void> modifyAckDeadline(int ackDeadlineSeconds) {
            return PubSubSubscriberTemplate.this.modifyAckDeadline(Collections.singleton(this), ackDeadlineSeconds);
        }

        public String toString() {
            return "PulledAcknowledgeablePubsubMessage{projectId='" + this.getProjectSubscriptionName().getProject() + '\'' + ", subscriptionName='" + this.getProjectSubscriptionName().getSubscription() + '\'' + ", message=" + this.getPubsubMessage() + ", ackId='" + this.ackId + '\'' + '}';
        }
    }

    private static abstract class AbstractBasicAcknowledgeablePubsubMessage
    implements BasicAcknowledgeablePubsubMessage {
        private final ProjectSubscriptionName projectSubscriptionName;
        private final PubsubMessage message;

        AbstractBasicAcknowledgeablePubsubMessage(ProjectSubscriptionName projectSubscriptionName, PubsubMessage message) {
            this.projectSubscriptionName = projectSubscriptionName;
            this.message = message;
        }

        @Override
        public ProjectSubscriptionName getProjectSubscriptionName() {
            return this.projectSubscriptionName;
        }

        @Override
        public PubsubMessage getPubsubMessage() {
            return this.message;
        }
    }
}

