/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support;

import com.google.api.gax.batching.BatchingSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.pubsub.core.PubSubException;
import com.google.cloud.spring.pubsub.support.PubSubTopicUtils;
import com.google.cloud.spring.pubsub.support.PublisherFactory;
import com.google.pubsub.v1.TopicName;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.util.Assert;

public class DefaultPublisherFactory
implements PublisherFactory {
    private final String projectId;
    private final ConcurrentHashMap<String, Publisher> publishers = new ConcurrentHashMap();
    private ExecutorProvider executorProvider;
    private TransportChannelProvider channelProvider;
    private CredentialsProvider credentialsProvider;
    private HeaderProvider headerProvider;
    private RetrySettings retrySettings;
    private BatchingSettings batchingSettings;

    public DefaultPublisherFactory(GcpProjectIdProvider projectIdProvider) {
        Assert.notNull((Object)projectIdProvider, (String)"The project ID provider can't be null.");
        this.projectId = projectIdProvider.getProjectId();
        Assert.hasText((String)this.projectId, (String)"The project ID can't be null or empty.");
    }

    public void setExecutorProvider(ExecutorProvider executorProvider) {
        this.executorProvider = executorProvider;
    }

    public void setChannelProvider(TransportChannelProvider channelProvider) {
        this.channelProvider = channelProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setHeaderProvider(HeaderProvider headerProvider) {
        this.headerProvider = headerProvider;
    }

    public void setRetrySettings(RetrySettings retrySettings) {
        this.retrySettings = retrySettings;
    }

    public void setBatchingSettings(BatchingSettings batchingSettings) {
        this.batchingSettings = batchingSettings;
    }

    @Override
    public Publisher createPublisher(String topic) {
        return this.publishers.computeIfAbsent(topic, key -> {
            try {
                Publisher.Builder publisherBuilder = Publisher.newBuilder((TopicName)PubSubTopicUtils.toTopicName(topic, this.projectId));
                if (this.executorProvider != null) {
                    publisherBuilder.setExecutorProvider(this.executorProvider);
                }
                if (this.channelProvider != null) {
                    publisherBuilder.setChannelProvider(this.channelProvider);
                }
                if (this.credentialsProvider != null) {
                    publisherBuilder.setCredentialsProvider(this.credentialsProvider);
                }
                if (this.headerProvider != null) {
                    publisherBuilder.setHeaderProvider(this.headerProvider);
                }
                if (this.retrySettings != null) {
                    publisherBuilder.setRetrySettings(this.retrySettings);
                }
                if (this.batchingSettings != null) {
                    publisherBuilder.setBatchingSettings(this.batchingSettings);
                }
                return publisherBuilder.build();
            }
            catch (IOException ioe) {
                throw new PubSubException("An error creating the Google Cloud Pub/Sub publisher occurred.", ioe);
            }
        });
    }

    Map<String, Publisher> getCache() {
        return this.publishers;
    }
}

