/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.integration.inbound;

import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.spring.pubsub.core.subscriber.PubSubSubscriberOperations;
import com.google.cloud.spring.pubsub.integration.AckMode;
import com.google.cloud.spring.pubsub.integration.PubSubHeaderMapper;
import com.google.cloud.spring.pubsub.support.converter.ConvertedBasicAcknowledgeablePubsubMessage;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.endpoint.MessageProducerSupport;
import org.springframework.integration.mapping.HeaderMapper;
import org.springframework.messaging.MessageChannel;
import org.springframework.util.Assert;

public class PubSubInboundChannelAdapter
extends MessageProducerSupport {
    private static final Log LOGGER = LogFactory.getLog(PubSubInboundChannelAdapter.class);
    private final String subscriptionName;
    private final PubSubSubscriberOperations pubSubSubscriberOperations;
    private Subscriber subscriber;
    private AckMode ackMode = AckMode.AUTO;
    private HeaderMapper<Map<String, String>> headerMapper = new PubSubHeaderMapper();
    private Class<?> payloadType = byte[].class;

    public PubSubInboundChannelAdapter(PubSubSubscriberOperations pubSubSubscriberOperations, String subscriptionName) {
        Assert.notNull((Object)pubSubSubscriberOperations, (String)"Pub/Sub subscriber template can't be null.");
        Assert.notNull((Object)subscriptionName, (String)"Pub/Sub subscription name can't be null.");
        this.pubSubSubscriberOperations = pubSubSubscriberOperations;
        this.subscriptionName = subscriptionName;
    }

    public AckMode getAckMode() {
        return this.ackMode;
    }

    public void setAckMode(AckMode ackMode) {
        Assert.notNull((Object)((Object)ackMode), (String)"The acknowledgement mode can't be null.");
        this.ackMode = ackMode;
    }

    public Class<?> getPayloadType() {
        return this.payloadType;
    }

    public void setPayloadType(Class<?> payloadType) {
        Assert.notNull(payloadType, (String)"The payload type cannot be null.");
        this.payloadType = payloadType;
    }

    public void setHeaderMapper(HeaderMapper<Map<String, String>> headerMapper) {
        Assert.notNull(headerMapper, (String)"The header mapper can't be null.");
        this.headerMapper = headerMapper;
    }

    protected void doStart() {
        super.doStart();
        this.subscriber = this.pubSubSubscriberOperations.subscribeAndConvert(this.subscriptionName, this::consumeMessage, this.payloadType);
    }

    protected void doStop() {
        if (this.subscriber != null) {
            this.subscriber.stopAsync();
        }
        super.doStop();
    }

    private void consumeMessage(ConvertedBasicAcknowledgeablePubsubMessage<?> message) {
        Map messageHeaders = this.headerMapper.toHeaders((Object)message.getPubsubMessage().getAttributesMap());
        messageHeaders.put("gcp_pubsub_original_message", message);
        try {
            this.sendMessage(this.getMessageBuilderFactory().withPayload(message.getPayload()).copyHeaders(messageHeaders).build());
            if (this.ackMode == AckMode.AUTO_ACK || this.ackMode == AckMode.AUTO) {
                message.ack();
            }
        }
        catch (RuntimeException re) {
            if (this.ackMode == AckMode.AUTO) {
                message.nack();
                LOGGER.warn((Object)("Sending Spring message [" + message.getPubsubMessage().getMessageId() + "] failed; message nacked automatically."), (Throwable)re);
            }
            LOGGER.warn((Object)("Sending Spring message [" + message.getPubsubMessage().getMessageId() + "] failed; message neither acked nor nacked."), (Throwable)re);
        }
    }

    public MessageChannel getErrorChannel() {
        if (!this.isRunning()) {
            return null;
        }
        return super.getErrorChannel();
    }
}

