/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support;

import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.TopicName;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public final class PubSubTopicUtils {
    private PubSubTopicUtils() {
    }

    public static ProjectTopicName toProjectTopicName(String topic, @Nullable String projectId) {
        Assert.notNull((Object)topic, (String)"The topic can't be null.");
        ProjectTopicName projectTopicName = null;
        if (ProjectTopicName.isParsableFrom((String)topic)) {
            projectTopicName = ProjectTopicName.parse((String)topic);
        } else {
            Assert.notNull((Object)projectId, (String)"The project ID can't be null when using canonical topic name.");
            projectTopicName = ProjectTopicName.of((String)projectId, (String)topic);
        }
        return projectTopicName;
    }

    public static TopicName toTopicName(String topic, @Nullable String projectId) {
        ProjectTopicName ptn = PubSubTopicUtils.toProjectTopicName(topic, projectId);
        return TopicName.ofProjectTopicName((String)ptn.getProject(), (String)ptn.getTopic());
    }
}

