/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.core;

import com.google.api.gax.batching.FlowController;
import com.google.api.gax.rpc.StatusCode;
import com.google.cloud.spring.pubsub.support.PubSubSubscriptionUtils;
import com.google.pubsub.v1.ProjectSubscriptionName;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class PubSubConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(PubSubConfiguration.class);
    public static final int DEFAULT_EXECUTOR_THREADS = 4;
    private static final Long DEFAULT_MAX_ACK_EXTENSION_PERIOD = 0L;
    private Map<String, Subscriber> subscription = new HashMap<String, Subscriber>();
    private Map<ProjectSubscriptionName, Subscriber> fullyQualifiedSubscriptionProperties;
    private final Subscriber globalSubscriber = new Subscriber();
    private final Publisher publisher = new Publisher();
    private final Health health = new Health();

    public Subscriber getSubscriber() {
        return this.globalSubscriber;
    }

    public Publisher getPublisher() {
        return this.publisher;
    }

    public Health getHealth() {
        return this.health;
    }

    public void setSubscription(Map<String, Subscriber> subscriberProperties) {
        Assert.isNull(this.fullyQualifiedSubscriptionProperties, (String)"Pub/Sub properties have already been initialized; cannot update subscription properties");
        this.subscription = subscriberProperties;
    }

    public Map<ProjectSubscriptionName, Subscriber> getFullyQualifiedSubscriberProperties() {
        Assert.notNull(this.fullyQualifiedSubscriptionProperties, (String)"Please call initialize() prior to retrieving properties.");
        return this.fullyQualifiedSubscriptionProperties;
    }

    public void initialize(String defaultProjectId) {
        if (this.fullyQualifiedSubscriptionProperties != null) {
            logger.warn("Pub/Sub configuration can only be initialized once; ignoring request.");
            return;
        }
        HashMap<ProjectSubscriptionName, Subscriber> fullyQualifiedProps = new HashMap<ProjectSubscriptionName, Subscriber>();
        for (Map.Entry<String, Subscriber> entry : this.subscription.entrySet()) {
            Subscriber subscriberProperties = entry.getValue();
            String qualifiedName = subscriberProperties.fullyQualifiedName != null ? subscriberProperties.fullyQualifiedName : entry.getKey();
            ProjectSubscriptionName projectSubscriptionName = PubSubSubscriptionUtils.toProjectSubscriptionName(qualifiedName, defaultProjectId);
            if (fullyQualifiedProps.containsKey(projectSubscriptionName)) {
                logger.warn("Found multiple configurations for {}; ignoring properties with key {}", (Object)projectSubscriptionName, (Object)entry.getKey());
                continue;
            }
            fullyQualifiedProps.put(projectSubscriptionName, subscriberProperties);
        }
        this.fullyQualifiedSubscriptionProperties = Collections.unmodifiableMap(fullyQualifiedProps);
    }

    public Subscriber getSubscriptionProperties(ProjectSubscriptionName projectSubscriptionName) {
        Assert.notNull(this.fullyQualifiedSubscriptionProperties, (String)"Please call initialize() prior to retrieving properties.");
        if (this.fullyQualifiedSubscriptionProperties.containsKey(projectSubscriptionName)) {
            return this.fullyQualifiedSubscriptionProperties.get(projectSubscriptionName);
        }
        return this.globalSubscriber;
    }

    public FlowControl computeSubscriberFlowControlSettings(ProjectSubscriptionName projectSubscriptionName) {
        FlowControl flowControl = this.getSubscriptionProperties(projectSubscriptionName).getFlowControl();
        FlowControl globalFlowControl = this.globalSubscriber.getFlowControl();
        if (flowControl.getMaxOutstandingRequestBytes() == null) {
            flowControl.setMaxOutstandingRequestBytes(globalFlowControl.getMaxOutstandingRequestBytes());
        }
        if (flowControl.getMaxOutstandingElementCount() == null) {
            flowControl.setMaxOutstandingElementCount(globalFlowControl.getMaxOutstandingElementCount());
        }
        if (flowControl.getLimitExceededBehavior() == null) {
            flowControl.setLimitExceededBehavior(globalFlowControl.getLimitExceededBehavior());
        }
        return flowControl;
    }

    public Integer computeParallelPullCount(String subscriptionName, String projectId) {
        Integer parallelPullCount = this.getSubscriptionProperties(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, projectId)).getParallelPullCount();
        return parallelPullCount != null ? parallelPullCount : this.globalSubscriber.getParallelPullCount();
    }

    public StatusCode.Code[] computeRetryableCodes(String subscriptionName, String projectId) {
        StatusCode.Code[] retryableCodes = this.getSubscriptionProperties(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, projectId)).getRetryableCodes();
        return retryableCodes != null ? retryableCodes : this.globalSubscriber.getRetryableCodes();
    }

    public Long computeMaxAckExtensionPeriod(String subscriptionName, String projectId) {
        Long maxAckExtensionPeriod = this.getSubscriptionProperties(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, projectId)).getMaxAckExtensionPeriod();
        if (maxAckExtensionPeriod != null) {
            return maxAckExtensionPeriod;
        }
        Long globalMaxAckExtensionPeriod = this.globalSubscriber.getMaxAckExtensionPeriod();
        return globalMaxAckExtensionPeriod != null ? globalMaxAckExtensionPeriod : DEFAULT_MAX_ACK_EXTENSION_PERIOD;
    }

    @Nullable
    public Long computeMinDurationPerAckExtension(String subscriptionName, String projectId) {
        Long minDurationPerAckExtension = this.getSubscriptionProperties(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, projectId)).getMinDurationPerAckExtension();
        if (minDurationPerAckExtension != null) {
            return minDurationPerAckExtension;
        }
        return this.globalSubscriber.getMinDurationPerAckExtension();
    }

    @Nullable
    public Long computeMaxDurationPerAckExtension(String subscriptionName, String projectId) {
        Long maxDurationPerAckExtension = this.getSubscriptionProperties(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, projectId)).getMaxDurationPerAckExtension();
        if (maxDurationPerAckExtension != null) {
            return maxDurationPerAckExtension;
        }
        return this.globalSubscriber.getMaxDurationPerAckExtension();
    }

    public String computePullEndpoint(String subscriptionName, String projectId) {
        String pullEndpoint = this.getSubscriptionProperties(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, projectId)).getPullEndpoint();
        return pullEndpoint != null ? pullEndpoint : this.globalSubscriber.getPullEndpoint();
    }

    public String computeSubscriberUniverseDomain(String subscriptionName, String projectId) {
        String universeDomain = this.getSubscriptionProperties(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, projectId)).getUniverseDomain();
        return universeDomain != null ? universeDomain : this.globalSubscriber.getUniverseDomain();
    }

    public Retry computeSubscriberRetrySettings(ProjectSubscriptionName projectSubscriptionName) {
        Retry retry = this.getSubscriptionProperties(projectSubscriptionName).getRetry();
        Retry globalRetry = this.globalSubscriber.getRetry();
        if (retry.getTotalTimeoutSeconds() == null) {
            retry.setTotalTimeoutSeconds(globalRetry.getTotalTimeoutSeconds());
        }
        if (retry.getInitialRetryDelaySeconds() == null) {
            retry.setInitialRetryDelaySeconds(globalRetry.getInitialRetryDelaySeconds());
        }
        if (retry.getRetryDelayMultiplier() == null) {
            retry.setRetryDelayMultiplier(globalRetry.getRetryDelayMultiplier());
        }
        if (retry.getMaxRetryDelaySeconds() == null) {
            retry.setMaxRetryDelaySeconds(globalRetry.getMaxRetryDelaySeconds());
        }
        if (retry.getMaxAttempts() == null) {
            retry.setMaxAttempts(globalRetry.getMaxAttempts());
        }
        if (retry.getJittered() == null) {
            retry.setJittered(globalRetry.getJittered());
        }
        if (retry.getInitialRpcTimeoutSeconds() == null) {
            retry.setInitialRpcTimeoutSeconds(globalRetry.getInitialRpcTimeoutSeconds());
        }
        if (retry.getRpcTimeoutMultiplier() == null) {
            retry.setRpcTimeoutMultiplier(globalRetry.getRpcTimeoutMultiplier());
        }
        if (retry.getMaxRpcTimeoutSeconds() == null) {
            retry.setMaxRpcTimeoutSeconds(globalRetry.getMaxRpcTimeoutSeconds());
        }
        return retry;
    }

    public static class Subscriber {
        private String fullyQualifiedName;
        private Integer executorThreads;
        private int maxAcknowledgementThreads = 4;
        private String pullEndpoint;
        private Long maxAckExtensionPeriod;
        private Long minDurationPerAckExtension;
        private Long maxDurationPerAckExtension;
        private Integer parallelPullCount;
        private final Retry retry = new Retry();
        private final FlowControl flowControl = new FlowControl();
        private StatusCode.Code[] retryableCodes = null;
        private String universeDomain;

        public String getFullyQualifiedName() {
            return this.fullyQualifiedName;
        }

        public void setFullyQualifiedName(String fullyQualifiedName) {
            this.fullyQualifiedName = fullyQualifiedName;
        }

        public Retry getRetry() {
            return this.retry;
        }

        public StatusCode.Code[] getRetryableCodes() {
            return this.retryableCodes;
        }

        public void setRetryableCodes(StatusCode.Code[] retryableCodes) {
            this.retryableCodes = retryableCodes;
        }

        public FlowControl getFlowControl() {
            return this.flowControl;
        }

        public String getPullEndpoint() {
            return this.pullEndpoint;
        }

        public void setPullEndpoint(String pullEndpoint) {
            this.pullEndpoint = pullEndpoint;
        }

        public Long getMaxAckExtensionPeriod() {
            return this.maxAckExtensionPeriod;
        }

        public void setMaxAckExtensionPeriod(Long maxAckExtensionPeriod) {
            this.maxAckExtensionPeriod = maxAckExtensionPeriod;
        }

        public Long getMinDurationPerAckExtension() {
            return this.minDurationPerAckExtension;
        }

        public void setMinDurationPerAckExtension(Long minDurationPerAckExtension) {
            this.minDurationPerAckExtension = minDurationPerAckExtension;
        }

        public Long getMaxDurationPerAckExtension() {
            return this.maxDurationPerAckExtension;
        }

        public void setMaxDurationPerAckExtension(Long maxDurationPerAckExtension) {
            this.maxDurationPerAckExtension = maxDurationPerAckExtension;
        }

        public Integer getParallelPullCount() {
            return this.parallelPullCount;
        }

        public void setParallelPullCount(Integer parallelPullCount) {
            this.parallelPullCount = parallelPullCount;
        }

        public Integer getExecutorThreads() {
            return this.executorThreads;
        }

        public void setExecutorThreads(int executorThreads) {
            this.executorThreads = executorThreads;
        }

        public int getMaxAcknowledgementThreads() {
            return this.maxAcknowledgementThreads;
        }

        public void setMaxAcknowledgementThreads(int maxAcknowledgementThreads) {
            this.maxAcknowledgementThreads = maxAcknowledgementThreads;
        }

        public String getUniverseDomain() {
            return this.universeDomain;
        }

        public void setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
        }
    }

    public static class Publisher {
        private int executorThreads = 4;
        private Boolean executorAcceptTasksAfterContextClose = false;
        private Boolean executorWaitForTasksToCompleteOnShutdown = false;
        private Long executorAwaitTerminationMillis = 0L;
        private final Retry retry = new Retry();
        private final Batching batching = new Batching();
        private Boolean enableMessageOrdering;
        private String endpoint;
        private String universeDomain;

        public Batching getBatching() {
            return this.batching;
        }

        public Retry getRetry() {
            return this.retry;
        }

        public int getExecutorThreads() {
            return this.executorThreads;
        }

        public void setExecutorThreads(int executorThreads) {
            this.executorThreads = executorThreads;
        }

        public Boolean getExecutorAcceptTasksAfterContextClose() {
            return this.executorAcceptTasksAfterContextClose;
        }

        public void setExecutorAcceptTasksAfterContextClose(Boolean executorAcceptTasksAfterContextClose) {
            this.executorAcceptTasksAfterContextClose = executorAcceptTasksAfterContextClose;
        }

        public Boolean getExecutorWaitForTasksToCompleteOnShutdown() {
            return this.executorWaitForTasksToCompleteOnShutdown;
        }

        public void setExecutorWaitForTasksToCompleteOnShutdown(Boolean executorWaitForTasksToCompleteOnShutdown) {
            this.executorWaitForTasksToCompleteOnShutdown = executorWaitForTasksToCompleteOnShutdown;
        }

        public long getExecutorAwaitTerminationMillis() {
            return this.executorAwaitTerminationMillis;
        }

        public void setExecutorAwaitTerminationMillis(long executorAwaitTerminationMillis) {
            this.executorAwaitTerminationMillis = executorAwaitTerminationMillis;
        }

        public Boolean getEnableMessageOrdering() {
            return this.enableMessageOrdering;
        }

        public void setEnableMessageOrdering(Boolean enableMessageOrdering) {
            this.enableMessageOrdering = enableMessageOrdering;
        }

        public String getEndpoint() {
            return this.endpoint;
        }

        public void setEndpoint(String endpoint) {
            this.endpoint = endpoint;
        }

        public String getUniverseDomain() {
            return this.universeDomain;
        }

        public void setUniverseDomain(String universeDomain) {
            this.universeDomain = universeDomain;
        }
    }

    public static class Health {
        private Integer lagThreshold;
        private Integer backlogThreshold;
        private Integer lookUpInterval = 1;
        private int executorThreads = 4;

        public Integer getLagThreshold() {
            return this.lagThreshold;
        }

        public void setLagThreshold(Integer lagThreshold) {
            this.lagThreshold = lagThreshold;
        }

        public Integer getBacklogThreshold() {
            return this.backlogThreshold;
        }

        public void setBacklogThreshold(Integer backlogThreshold) {
            this.backlogThreshold = backlogThreshold;
        }

        public Integer getLookUpInterval() {
            return this.lookUpInterval;
        }

        public void setLookUpInterval(Integer lookUpInterval) {
            this.lookUpInterval = lookUpInterval;
        }

        public int getExecutorThreads() {
            return this.executorThreads;
        }

        public void setExecutorThreads(int executorThreads) {
            this.executorThreads = executorThreads;
        }
    }

    public static class FlowControl {
        private Long maxOutstandingElementCount;
        private Long maxOutstandingRequestBytes;
        private FlowController.LimitExceededBehavior limitExceededBehavior;

        public Long getMaxOutstandingElementCount() {
            return this.maxOutstandingElementCount;
        }

        public void setMaxOutstandingElementCount(Long maxOutstandingElementCount) {
            this.maxOutstandingElementCount = maxOutstandingElementCount;
        }

        public Long getMaxOutstandingRequestBytes() {
            return this.maxOutstandingRequestBytes;
        }

        public void setMaxOutstandingRequestBytes(Long maxOutstandingRequestBytes) {
            this.maxOutstandingRequestBytes = maxOutstandingRequestBytes;
        }

        public FlowController.LimitExceededBehavior getLimitExceededBehavior() {
            return this.limitExceededBehavior;
        }

        public void setLimitExceededBehavior(FlowController.LimitExceededBehavior limitExceededBehavior) {
            this.limitExceededBehavior = limitExceededBehavior;
        }
    }

    public static class Retry {
        private Long totalTimeoutSeconds;
        private Long initialRetryDelaySeconds;
        private Double retryDelayMultiplier;
        private Long maxRetryDelaySeconds;
        private Integer maxAttempts;
        private Boolean jittered;
        private Long initialRpcTimeoutSeconds;
        private Double rpcTimeoutMultiplier;
        private Long maxRpcTimeoutSeconds;

        public Long getTotalTimeoutSeconds() {
            return this.totalTimeoutSeconds;
        }

        public void setTotalTimeoutSeconds(Long totalTimeoutSeconds) {
            this.totalTimeoutSeconds = totalTimeoutSeconds;
        }

        public Long getInitialRetryDelaySeconds() {
            return this.initialRetryDelaySeconds;
        }

        public void setInitialRetryDelaySeconds(Long initialRetryDelaySeconds) {
            this.initialRetryDelaySeconds = initialRetryDelaySeconds;
        }

        public Double getRetryDelayMultiplier() {
            return this.retryDelayMultiplier;
        }

        public void setRetryDelayMultiplier(Double retryDelayMultiplier) {
            this.retryDelayMultiplier = retryDelayMultiplier;
        }

        public Long getMaxRetryDelaySeconds() {
            return this.maxRetryDelaySeconds;
        }

        public void setMaxRetryDelaySeconds(Long maxRetryDelaySeconds) {
            this.maxRetryDelaySeconds = maxRetryDelaySeconds;
        }

        public Integer getMaxAttempts() {
            return this.maxAttempts;
        }

        public void setMaxAttempts(Integer maxAttempts) {
            this.maxAttempts = maxAttempts;
        }

        public Boolean getJittered() {
            return this.jittered;
        }

        public void setJittered(Boolean jittered) {
            this.jittered = jittered;
        }

        public Long getInitialRpcTimeoutSeconds() {
            return this.initialRpcTimeoutSeconds;
        }

        public void setInitialRpcTimeoutSeconds(Long initialRpcTimeoutSeconds) {
            this.initialRpcTimeoutSeconds = initialRpcTimeoutSeconds;
        }

        public Double getRpcTimeoutMultiplier() {
            return this.rpcTimeoutMultiplier;
        }

        public void setRpcTimeoutMultiplier(Double rpcTimeoutMultiplier) {
            this.rpcTimeoutMultiplier = rpcTimeoutMultiplier;
        }

        public Long getMaxRpcTimeoutSeconds() {
            return this.maxRpcTimeoutSeconds;
        }

        public void setMaxRpcTimeoutSeconds(Long maxRpcTimeoutSeconds) {
            this.maxRpcTimeoutSeconds = maxRpcTimeoutSeconds;
        }
    }

    public static class Batching {
        private final FlowControl flowControl = new FlowControl();
        private Long elementCountThreshold;
        private Long requestByteThreshold;
        private Long delayThresholdSeconds;
        private Boolean enabled;

        public Long getElementCountThreshold() {
            return this.elementCountThreshold;
        }

        public void setElementCountThreshold(Long elementCountThreshold) {
            this.elementCountThreshold = elementCountThreshold;
        }

        public Long getRequestByteThreshold() {
            return this.requestByteThreshold;
        }

        public void setRequestByteThreshold(Long requestByteThreshold) {
            this.requestByteThreshold = requestByteThreshold;
        }

        public Long getDelayThresholdSeconds() {
            return this.delayThresholdSeconds;
        }

        public void setDelayThresholdSeconds(Long delayThresholdSeconds) {
            this.delayThresholdSeconds = delayThresholdSeconds;
        }

        public Boolean getEnabled() {
            return this.enabled;
        }

        public void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public FlowControl getFlowControl() {
            return this.flowControl;
        }
    }
}

