/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.secretmanager;

import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.secretmanager.SecretManagerPropertySource;
import com.google.cloud.spring.secretmanager.SecretManagerTemplate;
import org.springframework.cloud.bootstrap.config.PropertySourceLocator;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;

public class SecretManagerPropertySourceLocator
implements PropertySourceLocator {
    private static final String SECRET_MANAGER_NAME = "spring-cloud-gcp-secret-manager";
    private final SecretManagerTemplate template;
    private final GcpProjectIdProvider projectIdProvider;

    public SecretManagerPropertySourceLocator(SecretManagerTemplate template, GcpProjectIdProvider projectIdProvider) {
        this.template = template;
        this.projectIdProvider = projectIdProvider;
    }

    public PropertySource<?> locate(Environment environment) {
        return new SecretManagerPropertySource(SECRET_MANAGER_NAME, this.template, this.projectIdProvider);
    }
}

