/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.secretmanager;

import com.google.cloud.secretmanager.v1.SecretVersionName;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.secretmanager.SecretManagerPropertyUtils;
import com.google.cloud.spring.secretmanager.SecretManagerTemplate;
import org.springframework.core.env.EnumerablePropertySource;

public class SecretManagerPropertySource
extends EnumerablePropertySource<SecretManagerTemplate> {
    private final GcpProjectIdProvider projectIdProvider;

    public SecretManagerPropertySource(String propertySourceName, SecretManagerTemplate secretManagerTemplate, GcpProjectIdProvider projectIdProvider) {
        super(propertySourceName, (Object)secretManagerTemplate);
        this.projectIdProvider = projectIdProvider;
    }

    public Object getProperty(String name) {
        SecretVersionName secretIdentifier = SecretManagerPropertyUtils.getSecretVersionName(name, this.projectIdProvider);
        if (secretIdentifier != null) {
            return ((SecretManagerTemplate)this.getSource()).getSecretByteString(secretIdentifier);
        }
        return null;
    }

    public String[] getPropertyNames() {
        return new String[0];
    }
}

