/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.secretmanager;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;

public class SecretManagerSyntaxUtils {
    private static final String DEPRECATED_PREFIX = "sm://";
    private static final String PREFERRED_PREFIX = "sm@";
    public static final List<String> PREFIXES = ImmutableList.of((Object)"sm@", (Object)"sm://");

    public static Optional<String> getMatchedPrefixes(PrefixMatcher matcher) {
        return PREFIXES.stream().filter(matcher::matches).findFirst();
    }

    public static void warnIfUsingDeprecatedSyntax(Logger logger, String value) {
        if (!logger.isWarnEnabled() || !value.startsWith(DEPRECATED_PREFIX)) {
            return;
        }
        logger.warn(String.format("Detected usage of deprecated prefix %s. This may be removed in a future version of Spring Cloud GCP. Please use the new prefix %s instead.", DEPRECATED_PREFIX, PREFERRED_PREFIX));
    }

    @FunctionalInterface
    public static interface PrefixMatcher {
        public boolean matches(String var1);
    }
}

