/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.security.firebase;

import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedList;
import java.util.List;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.OAuth2TokenValidator;
import org.springframework.security.oauth2.core.OAuth2TokenValidatorResult;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.util.Assert;

public class FirebaseTokenValidator
implements OAuth2TokenValidator<Jwt> {
    private final String projectId;
    private static final Duration DEFAULT_MAX_CLOCK_SKEW = Duration.of(60L, ChronoUnit.SECONDS);
    private final Duration clockSkew;
    private Clock clock = Clock.systemUTC();
    private static final String OAUTH2_ERROR_URI = "https://tools.ietf.org/html/rfc6750#section-3.1";

    public FirebaseTokenValidator(String projectId) {
        this(projectId, DEFAULT_MAX_CLOCK_SKEW);
    }

    public FirebaseTokenValidator(String projectId, Duration clockSkew) {
        Assert.notNull((Object)projectId, (String)"ProjectId can't be null");
        this.projectId = projectId;
        this.clockSkew = clockSkew;
    }

    public OAuth2TokenValidatorResult validate(Jwt token) {
        LinkedList<OAuth2Error> errors = new LinkedList<OAuth2Error>();
        this.validateAudience(errors, token);
        this.validateIssuedAt(errors, token);
        this.validateSubject(errors, token);
        this.validateAuthTime(errors, token);
        return OAuth2TokenValidatorResult.failure(errors);
    }

    private void validateIssuedAt(List<OAuth2Error> errors, Jwt token) {
        Instant issuedAt = token.getIssuedAt();
        if (issuedAt == null || Instant.now(this.clock).plus(this.clockSkew).isBefore(issuedAt)) {
            errors.add(new OAuth2Error("invalid_request", "iat claim header must be in the past", OAUTH2_ERROR_URI));
        }
    }

    private void validateSubject(List<OAuth2Error> errors, Jwt token) {
        String subject = token.getSubject();
        if (subject == null || subject.length() == 0) {
            errors.add(new OAuth2Error("invalid_request", "sub claim can not be empty", OAUTH2_ERROR_URI));
        }
    }

    private void validateAuthTime(List<OAuth2Error> errors, Jwt token) {
        Instant authTime = token.getClaimAsInstant("auth_time");
        if (authTime == null || Instant.now(this.clock).plus(this.clockSkew).isBefore(authTime)) {
            errors.add(new OAuth2Error("invalid_request", "auth_time claim header must be in the past", OAUTH2_ERROR_URI));
        }
    }

    private void validateAudience(List<OAuth2Error> errors, Jwt token) {
        List audiences = token.getAudience();
        if (audiences != null) {
            for (String audience : audiences) {
                if (!audience.equals(this.projectId)) continue;
                return;
            }
        }
        errors.add(new OAuth2Error("invalid_request", "This aud claim is not equal to the configured audience", OAUTH2_ERROR_URI));
    }
}

