/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage.integration;

import com.google.cloud.WriteChannel;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.file.remote.session.Session;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public class GcsSession
implements Session<BlobInfo> {
    private Storage gcs;
    private static final Log LOGGER = LogFactory.getLog(GcsSession.class);
    private static final String SEPARATOR = "/";

    public GcsSession(Storage gcs) {
        Assert.notNull((Object)gcs, (String)"The GCS client can't be null.");
        this.gcs = gcs;
    }

    public boolean remove(String path) throws IOException {
        String[] tokens = this.getBucketAndObjectFromPath(path);
        Assert.state((tokens.length == 1 || tokens.length == 2 ? 1 : 0) != 0, (String)"Path must be in the form of [bucket] or [bucket]/[blob name]");
        return tokens.length == 1 ? this.gcs.delete(tokens[0], new Storage.BucketSourceOption[0]) : this.gcs.delete(tokens[0], tokens[1], new Storage.BlobSourceOption[0]);
    }

    public BlobInfo[] list(String path) throws IOException {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        for (Blob blob : this.gcs.list(path, new Storage.BlobListOption[0]).iterateAll()) {
            blobs.add(blob);
        }
        return blobs.toArray(new BlobInfo[blobs.size()]);
    }

    public void read(String source, OutputStream outputStream) throws IOException {
        String[] tokens = this.getBucketAndObjectFromPath(source);
        Assert.state((tokens.length == 2 ? 1 : 0) != 0, (String)"Can only read files, not buckets.");
        try (OutputStream os = outputStream;){
            os.write(this.gcs.readAllBytes(tokens[0], tokens[1], new Storage.BlobSourceOption[0]));
        }
    }

    public void write(InputStream inputStream, String destination) throws IOException {
        String[] tokens = this.getBucketAndObjectFromPath(destination);
        Assert.state((tokens.length == 2 ? 1 : 0) != 0, (String)"Can only write to files, not buckets.");
        BlobInfo gcsBlobInfo = BlobInfo.newBuilder((BlobId)BlobId.of((String)tokens[0], (String)tokens[1])).build();
        try (InputStream is = inputStream;
             WriteChannel channel = this.gcs.writer(gcsBlobInfo, new Storage.BlobWriteOption[0]);){
            channel.write(ByteBuffer.wrap(StreamUtils.copyToByteArray((InputStream)is)));
        }
    }

    public void append(InputStream inputStream, String destination) throws IOException {
        throw new UnsupportedOperationException("Appending isn't supported by Google Cloud Storage.");
    }

    public boolean mkdir(String directory) throws IOException {
        try {
            this.gcs.create(BucketInfo.of((String)directory), new Storage.BucketTargetOption[0]);
            return true;
        }
        catch (StorageException se) {
            LOGGER.info((Object)"Error creating the GCS bucket.", (Throwable)se);
            return false;
        }
    }

    public boolean rmdir(String directory) throws IOException {
        return this.gcs.delete(directory, new Storage.BucketSourceOption[0]);
    }

    public void rename(String pathFrom, String pathTo) throws IOException {
        String[] fromTokens = this.getBucketAndObjectFromPath(pathFrom);
        String[] toTokens = this.getBucketAndObjectFromPath(pathTo);
        BlobId source = BlobId.of((String)fromTokens[0], (String)fromTokens[1]);
        BlobId target = BlobId.of((String)toTokens[0], (String)toTokens[1]);
        Storage.CopyRequest copyRequest = Storage.CopyRequest.of((BlobId)source, (BlobId)target);
        this.gcs.copy(copyRequest);
        this.gcs.delete(source);
    }

    public void close() {
    }

    public boolean isOpen() {
        return true;
    }

    public boolean exists(String path) throws IOException {
        String[] tokens = this.getBucketAndObjectFromPath(path);
        return tokens.length == 1 ? this.gcs.get(path, new Storage.BucketGetOption[0]) != null : this.gcs.get(tokens[0], tokens[1], new Storage.BlobGetOption[0]) != null;
    }

    public String[] listNames(String path) throws IOException {
        List<String> names = Stream.of(this.list(path)).map(BlobInfo::getName).collect(Collectors.toList());
        return names.toArray(new String[names.size()]);
    }

    public InputStream readRaw(String source) throws IOException {
        String[] tokens = this.getBucketAndObjectFromPath(source);
        Assert.state((tokens.length == 2 ? 1 : 0) != 0, (String)"Can only write to files, not buckets.");
        return Channels.newInputStream((ReadableByteChannel)this.gcs.reader(tokens[0], tokens[1], new Storage.BlobSourceOption[0]));
    }

    public boolean finalizeRaw() throws IOException {
        return true;
    }

    public Object getClientInstance() {
        return this.gcs;
    }

    public String getHostPort() {
        return "storage.googleapis.com:443";
    }

    private String[] getBucketAndObjectFromPath(String path) throws IOException {
        Assert.hasText((String)path, (String)"Path can't be empty.");
        return path.split(SEPARATOR, 2);
    }
}

