/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage.integration.filters;

import com.google.cloud.storage.BlobInfo;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.springframework.integration.file.filters.DiscardAwareFileListFilter;

public class GcsAcceptModifiedAfterFileListFilter
implements DiscardAwareFileListFilter<BlobInfo> {
    private final long acceptAfterCutoffTimestamp;
    @Nullable
    private Consumer<BlobInfo> discardCallback;

    public GcsAcceptModifiedAfterFileListFilter() {
        this.acceptAfterCutoffTimestamp = Instant.now(Clock.systemUTC()).toEpochMilli();
    }

    public GcsAcceptModifiedAfterFileListFilter(Instant instant) {
        this.acceptAfterCutoffTimestamp = instant.toEpochMilli();
    }

    public void addDiscardCallback(@Nullable Consumer<BlobInfo> discardCallback) {
        this.discardCallback = discardCallback;
    }

    public List<BlobInfo> filterFiles(BlobInfo[] blobInfos) {
        ArrayList<BlobInfo> list = new ArrayList<BlobInfo>();
        for (BlobInfo file : blobInfos) {
            if (!this.accept(file)) continue;
            list.add(file);
        }
        return list;
    }

    public boolean accept(BlobInfo file) {
        if (this.fileUpdateTimeOnOrAfterPointInTime(file)) {
            return true;
        }
        if (this.discardCallback != null) {
            this.discardCallback.accept(file);
        }
        return false;
    }

    private boolean fileUpdateTimeOnOrAfterPointInTime(BlobInfo file) {
        return file.getUpdateTime() >= this.acceptAfterCutoffTimestamp;
    }

    public boolean supportsSingleFileFiltering() {
        return true;
    }
}

