/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage.integration.filters;

import com.google.cloud.storage.BlobInfo;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.springframework.integration.file.filters.DiscardAwareFileListFilter;
import org.springframework.lang.Nullable;

public class GcsDiscardRecentModifiedFileListFilter
implements DiscardAwareFileListFilter<BlobInfo> {
    private final Duration age;
    @Nullable
    private Consumer<BlobInfo> discardCallback;

    public GcsDiscardRecentModifiedFileListFilter(Duration age) {
        this.age = age;
    }

    public void addDiscardCallback(@Nullable Consumer<BlobInfo> discardCallbackToSet) {
        this.discardCallback = discardCallbackToSet;
    }

    public List<BlobInfo> filterFiles(BlobInfo[] files) {
        ArrayList<BlobInfo> list = new ArrayList<BlobInfo>();
        for (BlobInfo file : files) {
            if (!this.accept(file)) continue;
            list.add(file);
        }
        return list;
    }

    public boolean accept(BlobInfo file) {
        if (this.fileIsAged(file)) {
            return true;
        }
        if (this.discardCallback != null) {
            this.discardCallback.accept(file);
        }
        return false;
    }

    private boolean fileIsAged(BlobInfo file) {
        return file.getUpdateTime() + this.age.toMillis() <= System.currentTimeMillis();
    }

    public boolean supportsSingleFileFiltering() {
        return true;
    }
}

