/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.storage.integration;

import com.google.cloud.storage.BlobInfo;
import java.util.Date;
import org.springframework.integration.file.remote.AbstractFileInfo;
import org.springframework.util.Assert;

public class GcsFileInfo
extends AbstractFileInfo<BlobInfo> {
    private BlobInfo gcsFile;

    public GcsFileInfo(BlobInfo gcsFile) {
        Assert.notNull((Object)gcsFile, (String)"The GCS blob can't be null.");
        this.gcsFile = gcsFile;
    }

    public boolean isDirectory() {
        return this.gcsFile.isDirectory();
    }

    public boolean isLink() {
        return false;
    }

    public long getSize() {
        return this.gcsFile.getSize();
    }

    public long getModified() {
        return this.gcsFile.getUpdateTime();
    }

    public String getFilename() {
        return this.gcsFile.getName();
    }

    public String getPermissions() {
        throw new UnsupportedOperationException("Use [BlobInfo.getAcl()] to obtain permissions.");
    }

    public BlobInfo getFileInfo() {
        return this.gcsFile;
    }

    public String toString() {
        return "FileInfo [isDirectory=" + this.isDirectory() + ", isLink=" + this.isLink() + ", Size=" + this.getSize() + ", ModifiedTime=" + new Date(this.getModified()) + ", Filename=" + this.getFilename() + ", RemoteDirectory=" + this.getRemoteDirectory() + "]";
    }
}

