/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.vision;

import com.google.cloud.spring.vision.CloudVisionException;
import com.google.cloud.vision.v1.AnnotateFileRequest;
import com.google.cloud.vision.v1.AnnotateFileResponse;
import com.google.cloud.vision.v1.AnnotateImageRequest;
import com.google.cloud.vision.v1.AnnotateImageResponse;
import com.google.cloud.vision.v1.BatchAnnotateFilesRequest;
import com.google.cloud.vision.v1.BatchAnnotateFilesResponse;
import com.google.cloud.vision.v1.BatchAnnotateImagesRequest;
import com.google.cloud.vision.v1.BatchAnnotateImagesResponse;
import com.google.cloud.vision.v1.Feature;
import com.google.cloud.vision.v1.Image;
import com.google.cloud.vision.v1.ImageAnnotatorClient;
import com.google.cloud.vision.v1.ImageContext;
import com.google.cloud.vision.v1.InputConfig;
import com.google.protobuf.ByteString;
import com.google.rpc.Code;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class CloudVisionTemplate {
    public static final String READ_BYTES_ERROR_MESSAGE = "Failed to read bytes from provided resource.";
    public static final String EMPTY_RESPONSE_ERROR_MESSAGE = "Failed to receive valid response Vision APIs; empty response received.";
    private final ImageAnnotatorClient imageAnnotatorClient;

    public CloudVisionTemplate(ImageAnnotatorClient imageAnnotatorClient) {
        Assert.notNull((Object)imageAnnotatorClient, (String)"imageAnnotatorClient must not be null.");
        this.imageAnnotatorClient = imageAnnotatorClient;
    }

    public String extractTextFromImage(Resource imageResource) {
        return this.extractTextFromImage(imageResource, ImageContext.getDefaultInstance());
    }

    public List<String> extractTextFromPdf(Resource fileResource) {
        return this.extractTextFromFile(fileResource, "application/pdf");
    }

    public String extractTextFromImage(Resource imageResource, ImageContext imageContext) {
        AnnotateImageResponse response = this.analyzeImage(imageResource, imageContext, Feature.Type.TEXT_DETECTION);
        String result = response.getFullTextAnnotation().getText();
        if (result.isEmpty() && response.getError().getCode() != Code.OK.getNumber()) {
            throw new CloudVisionException(response.getError().getMessage());
        }
        return result;
    }

    public List<String> extractTextFromFile(Resource fileResource, String mimeType) {
        AnnotateFileResponse response = this.analyzeFile(fileResource, mimeType, Feature.Type.DOCUMENT_TEXT_DETECTION);
        List annotateImageResponses = response.getResponsesList();
        if (annotateImageResponses.isEmpty()) {
            throw new CloudVisionException(EMPTY_RESPONSE_ERROR_MESSAGE);
        }
        List<String> result = annotateImageResponses.stream().map(annotateImageResponse -> annotateImageResponse.getFullTextAnnotation().getText()).collect(Collectors.toList());
        if (result.isEmpty() && response.getError().getCode() != Code.OK.getNumber()) {
            throw new CloudVisionException(response.getError().getMessage());
        }
        return result;
    }

    public AnnotateImageResponse analyzeImage(Resource imageResource, Feature.Type ... featureTypes) {
        return this.analyzeImage(imageResource, ImageContext.getDefaultInstance(), featureTypes);
    }

    public AnnotateImageResponse analyzeImage(Resource imageResource, ImageContext imageContext, Feature.Type ... featureTypes) {
        ByteString imgBytes;
        try {
            imgBytes = ByteString.readFrom((InputStream)imageResource.getInputStream());
        }
        catch (IOException ex) {
            throw new CloudVisionException(READ_BYTES_ERROR_MESSAGE, ex);
        }
        Image image = Image.newBuilder().setContent(imgBytes).build();
        List featureList = Arrays.stream(featureTypes).map(featureType -> Feature.newBuilder().setType(featureType).build()).collect(Collectors.toList());
        BatchAnnotateImagesRequest request = BatchAnnotateImagesRequest.newBuilder().addRequests(AnnotateImageRequest.newBuilder().addAllFeatures(featureList).setImageContext(imageContext).setImage(image)).build();
        BatchAnnotateImagesResponse batchResponse = this.imageAnnotatorClient.batchAnnotateImages(request);
        List annotateImageResponses = batchResponse.getResponsesList();
        if (!annotateImageResponses.isEmpty()) {
            return (AnnotateImageResponse)annotateImageResponses.get(0);
        }
        throw new CloudVisionException(EMPTY_RESPONSE_ERROR_MESSAGE);
    }

    public AnnotateFileResponse analyzeFile(Resource fileResource, String mimeType, Feature.Type ... featureTypes) {
        ByteString imgBytes;
        try {
            imgBytes = ByteString.readFrom((InputStream)fileResource.getInputStream());
        }
        catch (IOException ex) {
            throw new CloudVisionException(READ_BYTES_ERROR_MESSAGE, ex);
        }
        InputConfig inputConfig = InputConfig.newBuilder().setMimeType(mimeType).setContent(imgBytes).build();
        List featureList = Arrays.stream(featureTypes).map(featureType -> Feature.newBuilder().setType(featureType).build()).collect(Collectors.toList());
        BatchAnnotateFilesRequest request = BatchAnnotateFilesRequest.newBuilder().addRequests(AnnotateFileRequest.newBuilder().addAllFeatures(featureList).setInputConfig(inputConfig).build()).build();
        BatchAnnotateFilesResponse response = this.imageAnnotatorClient.batchAnnotateFiles(request);
        List annotateFileResponses = response.getResponsesList();
        if (!annotateFileResponses.isEmpty()) {
            return (AnnotateFileResponse)annotateFileResponses.get(0);
        }
        throw new CloudVisionException(EMPTY_RESPONSE_ERROR_MESSAGE);
    }
}

