/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.vision;

import com.google.cloud.storage.Blob;
import com.google.cloud.vision.v1.AnnotateFileResponse;
import com.google.cloud.vision.v1.AnnotateImageResponse;
import com.google.cloud.vision.v1.TextAnnotation;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.util.JsonFormat;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

final class OcrPageRange {
    private static final Pattern OUTPUT_PAGE_PATTERN = Pattern.compile("output-(\\d+)-to-(\\d+)\\.json");
    private final Blob blob;
    private final int startPage;
    private final int endPage;
    private List<TextAnnotation> pages = null;

    OcrPageRange(Blob blob) {
        Matcher matcher = OUTPUT_PAGE_PATTERN.matcher(blob.getName());
        boolean success = matcher.find();
        if (!success) {
            throw new IllegalArgumentException("Cannot create a DocumentOcrResultSet with blob: " + blob.getName() + " Blob name does not contain suffix with the form: output-#-to-#.json");
        }
        this.blob = blob;
        this.startPage = Integer.parseInt(matcher.group(1));
        this.endPage = Integer.parseInt(matcher.group(2));
    }

    TextAnnotation getPage(int pageNumber) throws InvalidProtocolBufferException {
        if (pageNumber < this.startPage || pageNumber > this.endPage) {
            throw new IndexOutOfBoundsException("Page number not found: " + pageNumber + ". Could not find page in closest JSON output file: " + this.blob.getName());
        }
        int offsetIdx = pageNumber - this.startPage;
        return this.getPages().get(offsetIdx);
    }

    List<TextAnnotation> getPages() throws InvalidProtocolBufferException {
        if (this.pages == null) {
            this.pages = OcrPageRange.parseJsonBlob(this.blob);
        }
        return this.pages;
    }

    public Blob getBlob() {
        return this.blob;
    }

    int getStartPage() {
        return this.startPage;
    }

    int getEndPage() {
        return this.endPage;
    }

    private static List<TextAnnotation> parseJsonBlob(Blob blob) throws InvalidProtocolBufferException {
        AnnotateFileResponse.Builder annotateFileResponseBuilder = AnnotateFileResponse.newBuilder();
        String jsonContent = new String(blob.getContent(new Blob.BlobSourceOption[0]), StandardCharsets.UTF_8);
        JsonFormat.parser().ignoringUnknownFields().merge(jsonContent, (Message.Builder)annotateFileResponseBuilder);
        AnnotateFileResponse annotateFileResponse = annotateFileResponseBuilder.build();
        return annotateFileResponse.getResponsesList().stream().map(AnnotateImageResponse::getFullTextAnnotation).collect(Collectors.toList());
    }
}

