/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.sqlserver;

import com.google.cloud.sql.core.CoreSocketFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;

public class SocketFactory
extends javax.net.SocketFactory {
    @VisibleForTesting
    protected Properties props = new Properties();

    public SocketFactory(String socketFactoryConstructorArg) throws UnsupportedEncodingException {
        List s = Splitter.on((char)'?').splitToList((CharSequence)socketFactoryConstructorArg);
        this.props.setProperty("cloudSqlInstance", (String)s.get(0));
        if (s.size() == 2 && ((String)s.get(1)).length() > 0) {
            Iterable queryParams = Splitter.on((char)'&').split((CharSequence)s.get(1));
            for (String param : queryParams) {
                List splitParam = Splitter.on((char)'=').splitToList((CharSequence)param);
                if (splitParam.size() != 2 || ((String)splitParam.get(0)).length() == 0 || ((String)splitParam.get(1)).length() == 0) {
                    throw new IllegalArgumentException(String.format("Malformed query param in socketFactoryConstructorArg : %s", param));
                }
                this.props.setProperty(URLDecoder.decode((String)splitParam.get(0), StandardCharsets.UTF_8.name()), URLDecoder.decode((String)splitParam.get(1), StandardCharsets.UTF_8.name()));
            }
        } else if (s.size() > 2) {
            throw new IllegalArgumentException("Only one query string allowed in socketFactoryConstructorArg");
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        try {
            return CoreSocketFactory.connect((Properties)this.props);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Socket createSocket(String host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
        throw new UnsupportedOperationException();
    }

    static {
        CoreSocketFactory.addArtifactId((String)"cloud-sql-connector-jdbc-sqlserver");
    }
}

