/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.sqlserver;

import com.google.cloud.sql.core.CloudSqlInstanceName;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.InternalConnectorRegistry;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.URLDecoder;
import java.util.List;
import java.util.Properties;

public class SocketFactory
extends javax.net.SocketFactory {
    @VisibleForTesting
    protected Properties props = new Properties();
    @VisibleForTesting
    protected String domainName;

    public SocketFactory(String socketFactoryConstructorArg) throws UnsupportedEncodingException {
        List s = Splitter.on((char)'?').splitToList((CharSequence)socketFactoryConstructorArg);
        String instanceOrDomainName = (String)s.get(0);
        if (CloudSqlInstanceName.isValidInstanceName((String)instanceOrDomainName)) {
            this.props.setProperty("cloudSqlInstance", instanceOrDomainName);
        } else {
            this.domainName = instanceOrDomainName;
        }
        if (s.size() == 2 && ((String)s.get(1)).length() > 0) {
            Iterable queryParams = Splitter.on((char)'&').split((CharSequence)s.get(1));
            for (String param : queryParams) {
                List splitParam = Splitter.on((char)'=').splitToList((CharSequence)param);
                if (splitParam.size() != 2 || ((String)splitParam.get(0)).length() == 0 || ((String)splitParam.get(1)).length() == 0) {
                    throw new IllegalArgumentException(String.format("Malformed query param in socketFactoryConstructorArg : %s", param));
                }
                this.props.setProperty(URLDecoder.decode((String)splitParam.get(0), "utf-8"), URLDecoder.decode((String)splitParam.get(1), "utf-8"));
            }
        } else if (s.size() > 2) {
            throw new IllegalArgumentException("Only one query string allowed in socketFactoryConstructorArg");
        }
    }

    @Override
    public Socket createSocket() throws IOException {
        try {
            return InternalConnectorRegistry.getInstance().connect(ConnectionConfig.fromConnectionProperties((Properties)this.props, (String)this.domainName));
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Socket createSocket(String host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) {
        throw new UnsupportedOperationException();
    }

    static {
        InternalConnectorRegistry.addArtifactId((String)"cloud-sql-connector-jdbc-sqlserver");
    }
}

