/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlConnectionFactory;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.GcpConnectionFactoryProvider;
import com.google.cloud.sql.core.InternalConnectorRegistry;
import io.asyncer.r2dbc.mysql.MySqlConnectionFactoryProvider;
import io.asyncer.r2dbc.mysql.constant.SslMode;
import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.function.Function;

public class GcpConnectionFactoryProviderMysql
extends GcpConnectionFactoryProvider {
    private static final String MYSQL_DRIVER = "mysql";

    boolean supportedProtocol(String protocol) {
        return protocol.equals(MYSQL_DRIVER);
    }

    ConnectionFactory tcpSocketConnectionFactory(ConnectionConfig config, ConnectionFactoryOptions.Builder builder, Function<SslContextBuilder, SslContextBuilder> customizer) {
        builder.option(MySqlConnectionFactoryProvider.SSL_CONTEXT_BUILDER_CUSTOMIZER, customizer).option(MySqlConnectionFactoryProvider.SSL_MODE, (Object)SslMode.TUNNEL).option(MySqlConnectionFactoryProvider.TCP_NO_DELAY, (Object)true).option(MySqlConnectionFactoryProvider.TCP_KEEP_ALIVE, (Object)true);
        return new CloudSqlConnectionFactory(config, MySqlConnectionFactoryProvider::new, builder);
    }

    ConnectionFactory unixSocketConnectionFactory(ConnectionFactoryOptions.Builder optionBuilder, String socket) {
        optionBuilder.option(MySqlConnectionFactoryProvider.UNIX_SOCKET, (Object)socket);
        return new MySqlConnectionFactoryProvider().create(optionBuilder.build());
    }

    ConnectionFactoryOptions.Builder createBuilder(ConnectionFactoryOptions connectionFactoryOptions) {
        return connectionFactoryOptions.mutate().option(ConnectionFactoryOptions.DRIVER, (Object)MYSQL_DRIVER);
    }

    static {
        InternalConnectorRegistry.addArtifactId((String)"cloud-sql-connector-r2dbc-mysql");
    }
}

