/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlConnectionFactory;
import com.google.cloud.sql.core.CoreSocketFactory;
import com.google.cloud.sql.core.GcpConnectionFactoryProvider;
import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.postgresql.PostgresqlConnectionFactoryProvider;
import io.r2dbc.postgresql.client.SSLMode;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.function.Function;

public class GcpConnectionFactoryProviderPostgres
extends GcpConnectionFactoryProvider {
    private static final String POSTGRESQL_DRIVER = "postgresql";
    private static final String LEGACY_POSTGRESQL_DRIVER = "postgres";

    boolean supportedProtocol(String protocol) {
        return protocol.equals(POSTGRESQL_DRIVER) || protocol.equals(LEGACY_POSTGRESQL_DRIVER);
    }

    ConnectionFactory tcpSocketConnectionFactory(ConnectionFactoryOptions.Builder builder, String ipTypes, Function<SslContextBuilder, SslContextBuilder> customizer, String hostname) {
        builder.option(PostgresqlConnectionFactoryProvider.SSL_CONTEXT_BUILDER_CUSTOMIZER, customizer).option(PostgresqlConnectionFactoryProvider.SSL_MODE, (Object)SSLMode.TUNNEL).option(PostgresqlConnectionFactoryProvider.TCP_NODELAY, (Object)true).option(PostgresqlConnectionFactoryProvider.TCP_KEEPALIVE, (Object)true);
        return new CloudSqlConnectionFactory(PostgresqlConnectionFactoryProvider::new, ipTypes, builder, hostname);
    }

    ConnectionFactory unixSocketConnectionFactory(ConnectionFactoryOptions.Builder optionBuilder, String socket) {
        optionBuilder.option(PostgresqlConnectionFactoryProvider.SOCKET, (Object)socket);
        return new PostgresqlConnectionFactoryProvider().create(optionBuilder.build());
    }

    ConnectionFactoryOptions.Builder createBuilder(ConnectionFactoryOptions connectionFactoryOptions) {
        return connectionFactoryOptions.mutate().option(ConnectionFactoryOptions.DRIVER, (Object)POSTGRESQL_DRIVER);
    }

    static {
        CoreSocketFactory.addArtifactId((String)"cloud-sql-connector-r2dbc-postgres");
    }
}

