/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.core;

import com.google.cloud.sql.core.CloudSqlConnectionFactory;
import com.google.cloud.sql.core.ConnectionConfig;
import com.google.cloud.sql.core.GcpConnectionFactoryProvider;
import com.google.cloud.sql.core.InternalConnectorRegistry;
import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.mssql.MssqlConnectionFactoryProvider;
import io.r2dbc.spi.ConnectionFactory;
import io.r2dbc.spi.ConnectionFactoryOptions;
import java.util.function.Function;

public class GcpConnectionFactoryProviderMssql
extends GcpConnectionFactoryProvider {
    private static final String MSSQL_DRIVER = "mssql";

    boolean supportedProtocol(String protocol) {
        return protocol.equals(MSSQL_DRIVER);
    }

    ConnectionFactory tcpSocketConnectionFactory(ConnectionConfig config, ConnectionFactoryOptions.Builder builder, Function<SslContextBuilder, SslContextBuilder> customizer) {
        builder.option(MssqlConnectionFactoryProvider.SSL_TUNNEL, customizer).option(MssqlConnectionFactoryProvider.TCP_NODELAY, (Object)true).option(MssqlConnectionFactoryProvider.TCP_KEEPALIVE, (Object)true);
        return new CloudSqlConnectionFactory(config, MssqlConnectionFactoryProvider::new, builder);
    }

    ConnectionFactory unixSocketConnectionFactory(ConnectionFactoryOptions.Builder optionBuilder, String socket) {
        throw new RuntimeException("UNIX socket connections are not supported");
    }

    ConnectionFactoryOptions.Builder createBuilder(ConnectionFactoryOptions connectionFactoryOptions) {
        return connectionFactoryOptions.mutate().option(ConnectionFactoryOptions.DRIVER, (Object)MSSQL_DRIVER);
    }

    static {
        InternalConnectorRegistry.addArtifactId((String)"cloud-sql-connector-r2dbc-mssql");
    }
}

