/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.mysql;

import com.google.cloud.sql.core.SslSocketFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.util.Properties;
import java.util.logging.Logger;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class SocketFactory
implements com.mysql.jdbc.SocketFactory {
    private static final Logger logger = Logger.getLogger(SocketFactory.class.getName());
    private static final String CloudSqlPrefix = "/cloudsql/";
    private Socket socket;

    public Socket connect(String hostname, int portNumber, Properties props) throws IOException {
        String instanceName = props.getProperty("cloudSqlInstance");
        Preconditions.checkArgument((instanceName != null ? 1 : 0) != 0, (Object)"cloudSqlInstance property not set. Please specify this property in the JDBC URL or the connection Properties with value in form \"project:region:instance\"");
        logger.info(String.format("Connecting to Cloud SQL instance [%s].", instanceName));
        String runtime = System.getenv("GAE_RUNTIME");
        if (runtime == null || runtime.isEmpty()) {
            this.socket = SslSocketFactory.getInstance().create(instanceName);
        } else {
            logger.info("Using GAE Unix Sockets");
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(CloudSqlPrefix + instanceName));
            this.socket = UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        }
        return this.socket;
    }

    public Socket beforeHandshake() {
        return this.socket;
    }

    public Socket afterHandshake() {
        return this.socket;
    }
}

