/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sql.postgres;

import com.google.cloud.sql.core.SslSocketFactory;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.logging.Logger;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;

public class SocketFactory
extends javax.net.SocketFactory {
    private static final Logger logger = Logger.getLogger(SocketFactory.class.getName());
    private static final String CloudSqlPrefix = "/cloudsql/";
    private static final String PostgreSqlSufix = "/.s.PGSQL.5432";
    private final String instanceName;

    public SocketFactory(String instanceName) {
        Preconditions.checkArgument((instanceName != null ? 1 : 0) != 0, (Object)"socketFactoryArg property not set. Please specify this property in the JDBC URL or the connection Properties with the instance connection name in form \"project:region:instance\"");
        this.instanceName = instanceName;
    }

    @Override
    public Socket createSocket() throws IOException {
        String gaeEnv = System.getenv("GAE_ENV");
        String runEnv = System.getProperty("com.google.appengine.runtime.environment");
        Boolean forceUnixSocket = System.getenv("CLOUD_SQL_FORCE_UNIX_SOCKET") != null;
        if (forceUnixSocket.booleanValue() || "standard".equals(gaeEnv) && "Production".equals(runEnv)) {
            logger.info(String.format("Connecting to Cloud SQL instance [%s] via unix socket.", this.instanceName));
            UnixSocketAddress socketAddress = new UnixSocketAddress(new File(CloudSqlPrefix + this.instanceName + PostgreSqlSufix));
            return UnixSocketChannel.open((UnixSocketAddress)socketAddress).socket();
        }
        logger.info(String.format("Connecting to Cloud SQL instance [%s] via ssl socket.", this.instanceName));
        return SslSocketFactory.getInstance().create(this.instanceName);
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress host, int port) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
        throw new UnsupportedOperationException();
    }
}

