/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sqlcommenter.schibernate;

import com.google.cloud.sqlcommenter.threadlocalstorage.SpanContextMetadata;
import com.google.cloud.sqlcommenter.threadlocalstorage.State;
import io.opencensus.trace.SpanContext;
import io.opencensus.trace.Tracer;
import io.opencensus.trace.Tracing;
import io.opentelemetry.api.trace.Span;
import org.hibernate.resource.jdbc.spi.StatementInspector;

public class SCHibernate
implements StatementInspector {
    private static final Tracer openCensusTracer = Tracing.getTracer();

    public String inspect(String sql) {
        State state = State.Holder.get();
        io.opentelemetry.api.trace.SpanContext spanContextOT = Span.current().getSpanContext();
        if (spanContextOT.isValid()) {
            if (spanContextOT.isSampled()) {
                state = State.newBuilder(state).withSpanContextMetadata(SpanContextMetadata.fromOpenTelemetryContext(spanContextOT)).build();
            }
        } else {
            SpanContext spanContext = openCensusTracer.getCurrentSpan().getContext();
            if (spanContext.isValid() && spanContext.getTraceOptions().isSampled()) {
                state = State.newBuilder(state).withSpanContextMetadata(SpanContextMetadata.fromOpenCensusContext(spanContext)).build();
            }
        }
        if (state == null) {
            return sql;
        }
        return state.formatAndAppendToSQL(sql);
    }
}

