/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.sqlcommenter.threadlocalstorage;

import io.opencensus.trace.Tracestate;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.TraceState;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public class SpanContextMetadata {
    private static final Logger logger = Logger.getLogger(SpanContextMetadata.class.getName());
    private static final String UTF8 = StandardCharsets.UTF_8.toString();
    private final String traceId;
    private final String spanId;
    private final byte traceOptions;
    private final String traceState;

    private SpanContextMetadata(String traceId, String spanId, byte traceOptions, @Nullable String traceState) {
        this.traceId = traceId;
        this.spanId = spanId;
        this.traceOptions = traceOptions;
        this.traceState = traceState;
    }

    public static SpanContextMetadata fromOpenCensusContext(io.opencensus.trace.SpanContext spanContext) {
        if (spanContext == null || !spanContext.isValid()) {
            return null;
        }
        String traceId = spanContext.getTraceId().toLowerBase16();
        String spanId = spanContext.getSpanId().toLowerBase16();
        byte traceOptions = spanContext.getTraceOptions().getByte();
        Tracestate traceState = spanContext.getTracestate();
        if (traceState.getEntries().isEmpty()) {
            return new SpanContextMetadata(traceId, spanId, traceOptions, null);
        }
        ArrayList<String> pairsList = new ArrayList<String>();
        for (Tracestate.Entry entry : traceState.getEntries()) {
            String key = entry.getKey();
            if (key.isEmpty()) continue;
            try {
                String value = entry.getValue();
                String encoded = URLEncoder.encode(String.format("%s=%s", key, value), UTF8);
                pairsList.add(encoded);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception when encoding Tracestate", e);
            }
        }
        String traceStateStr = String.join((CharSequence)",", pairsList);
        return new SpanContextMetadata(traceId, spanId, traceOptions, traceStateStr);
    }

    public static SpanContextMetadata fromOpenTelemetryContext(SpanContext spanContext) {
        if (spanContext == null || !spanContext.isValid()) {
            return null;
        }
        String traceId = spanContext.getTraceId();
        String spanId = spanContext.getSpanId();
        byte traceOptions = spanContext.getTraceFlags().asByte();
        TraceState traceState = spanContext.getTraceState();
        if (traceState.isEmpty()) {
            return new SpanContextMetadata(traceId, spanId, traceOptions, null);
        }
        ArrayList<String> pairsList = new ArrayList<String>();
        Map map = traceState.asMap();
        for (String key : map.keySet()) {
            if (key.isEmpty()) continue;
            try {
                String value = (String)map.get(key);
                String encoded = URLEncoder.encode(String.format("%s=%s", key, value), UTF8);
                pairsList.add(encoded);
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Exception when encoding Tracestate", e);
            }
        }
        String traceStateStr = String.join((CharSequence)",", pairsList);
        return new SpanContextMetadata(traceId, spanId, traceOptions, traceStateStr);
    }

    public String getTraceId() {
        return this.traceId;
    }

    public String getSpanId() {
        return this.spanId;
    }

    public byte getTraceOptions() {
        return this.traceOptions;
    }

    public String getTraceState() {
        return this.traceState;
    }
}

